rule win_ordinypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ordinypt"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b0485786c4500 50 8b06 0fb64018 8d0480 8b0485506c4500 }
            // n = 6, score = 200
            //   8b0485786c4500       | mov                 eax, dword ptr [eax*4 + 0x456c78]
            //   50                   | push                eax
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   0fb64018             | movzx               eax, byte ptr [eax + 0x18]
            //   8d0480               | lea                 eax, [eax + eax*4]
            //   8b0485506c4500       | mov                 eax, dword ptr [eax*4 + 0x456c50]

        $sequence_1 = { e8???????? 8b8524faffff ba???????? e8???????? 0f8430030000 8d9520faffff }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8b8524faffff         | mov                 eax, dword ptr [ebp - 0x5dc]
            //   ba????????           |                     
            //   e8????????           |                     
            //   0f8430030000         | je                  0x336
            //   8d9520faffff         | lea                 edx, [ebp - 0x5e0]

        $sequence_2 = { e8???????? 0f84ec0a0000 8d95fcfaffff 8b45fc e8???????? }
            // n = 5, score = 200
            //   e8????????           |                     
            //   0f84ec0a0000         | je                  0xaf2
            //   8d95fcfaffff         | lea                 edx, [ebp - 0x504]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     

        $sequence_3 = { ff5134 8b8340020000 895814 c74010404c4400 b201 a1???????? e8???????? }
            // n = 7, score = 200
            //   ff5134               | call                dword ptr [ecx + 0x34]
            //   8b8340020000         | mov                 eax, dword ptr [ebx + 0x240]
            //   895814               | mov                 dword ptr [eax + 0x14], ebx
            //   c74010404c4400       | mov                 dword ptr [eax + 0x10], 0x444c40
            //   b201                 | mov                 dl, 1
            //   a1????????           |                     
            //   e8????????           |                     

        $sequence_4 = { 8b85f0faffff ba???????? e8???????? 0f845c0a0000 }
            // n = 4, score = 200
            //   8b85f0faffff         | mov                 eax, dword ptr [ebp - 0x510]
            //   ba????????           |                     
            //   e8????????           |                     
            //   0f845c0a0000         | je                  0xa62

        $sequence_5 = { 8b04b548614500 50 8bc7 e8???????? 50 }
            // n = 5, score = 200
            //   8b04b548614500       | mov                 eax, dword ptr [esi*4 + 0x456148]
            //   50                   | push                eax
            //   8bc7                 | mov                 eax, edi
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_6 = { e8???????? 0f8424060000 8d9574faffff 8b45fc e8???????? 8b8574faffff ba???????? }
            // n = 7, score = 200
            //   e8????????           |                     
            //   0f8424060000         | je                  0x62a
            //   8d9574faffff         | lea                 edx, [ebp - 0x58c]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8b8574faffff         | mov                 eax, dword ptr [ebp - 0x58c]
            //   ba????????           |                     

        $sequence_7 = { 8d95dcfbffff 8b45fc e8???????? 8b85dcfbffff }
            // n = 4, score = 200
            //   8d95dcfbffff         | lea                 edx, [ebp - 0x424]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8b85dcfbffff         | mov                 eax, dword ptr [ebp - 0x424]

        $sequence_8 = { 66c74304b3d7 897308 c74324e42e4000 c7431c5c2a4000 }
            // n = 4, score = 100
            //   66c74304b3d7         | mov                 word ptr [ebx + 4], 0xd7b3
            //   897308               | mov                 dword ptr [ebx + 8], esi
            //   c74324e42e4000       | mov                 dword ptr [ebx + 0x24], 0x402ee4
            //   c7431c5c2a4000       | mov                 dword ptr [ebx + 0x1c], 0x402a5c

        $sequence_9 = { 84db 7407 c605????????01 33c0 8ac3 c68020e9450001 }
            // n = 6, score = 100
            //   84db                 | test                bl, bl
            //   7407                 | je                  9
            //   c605????????01       |                     
            //   33c0                 | xor                 eax, eax
            //   8ac3                 | mov                 al, bl
            //   c68020e9450001       | mov                 byte ptr [eax + 0x45e920], 1

        $sequence_10 = { c705????????682d4200 c705????????d82c4200 c705????????002e4200 c705????????982e4200 c705????????6c2f4200 }
            // n = 5, score = 100
            //   c705????????682d4200     |     
            //   c705????????d82c4200     |     
            //   c705????????002e4200     |     
            //   c705????????982e4200     |     
            //   c705????????6c2f4200     |     

        $sequence_11 = { e8???????? 8b85d0fcffff ba???????? e8???????? 0f84da060000 8d95ccfcffff }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8b85d0fcffff         | mov                 eax, dword ptr [ebp - 0x330]
            //   ba????????           |                     
            //   e8????????           |                     
            //   0f84da060000         | je                  0x6e0
            //   8d95ccfcffff         | lea                 edx, [ebp - 0x334]

        $sequence_12 = { 8b9548feffff b8???????? e8???????? 0bd8 8d953cfeffff 8b45fc e8???????? }
            // n = 7, score = 100
            //   8b9548feffff         | mov                 edx, dword ptr [ebp - 0x1b8]
            //   b8????????           |                     
            //   e8????????           |                     
            //   0bd8                 | or                  ebx, eax
            //   8d953cfeffff         | lea                 edx, [ebp - 0x1c4]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   e8????????           |                     

        $sequence_13 = { c605????????02 c705????????94524000 e8???????? 84c0 7405 e8???????? }
            // n = 6, score = 100
            //   c605????????02       |                     
            //   c705????????94524000     |     
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7405                 | je                  7
            //   e8????????           |                     

        $sequence_14 = { 833e03 7416 837e0400 7503 833e04 }
            // n = 5, score = 100
            //   833e03               | cmp                 dword ptr [esi], 3
            //   7416                 | je                  0x18
            //   837e0400             | cmp                 dword ptr [esi + 4], 0
            //   7503                 | jne                 5
            //   833e04               | cmp                 dword ptr [esi], 4

        $sequence_15 = { 33d2 8905???????? 8915???????? 68???????? e8???????? }
            // n = 5, score = 100
            //   33d2                 | xor                 edx, edx
            //   8905????????         |                     
            //   8915????????         |                     
            //   68????????           |                     
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1064960
}