rule win_orpcbackdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.orpcbackdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.orpcbackdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d45a4 50 e8???????? 59 6a0b 59 8bf0 }
            // n = 7, score = 100
            //   8d45a4               | lea                 eax, [ebp - 0x5c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   6a0b                 | push                0xb
            //   59                   | pop                 ecx
            //   8bf0                 | mov                 esi, eax

        $sequence_1 = { 8b4df0 e8???????? 8945d8 33c0 8b4de4 83c101 }
            // n = 6, score = 100
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   e8????????           |                     
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   33c0                 | xor                 eax, eax
            //   8b4de4               | mov                 ecx, dword ptr [ebp - 0x1c]
            //   83c101               | add                 ecx, 1

        $sequence_2 = { e8???????? 8d8d18ebfeff e8???????? 8d8d48f4feff e8???????? 8d8d30f4feff e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d8d18ebfeff         | lea                 ecx, [ebp - 0x114e8]
            //   e8????????           |                     
            //   8d8d48f4feff         | lea                 ecx, [ebp - 0x10bb8]
            //   e8????????           |                     
            //   8d8d30f4feff         | lea                 ecx, [ebp - 0x10bd0]
            //   e8????????           |                     

        $sequence_3 = { 50 8d8de8ecffff e8???????? ff30 8d8d10e9ffff e8???????? }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d8de8ecffff         | lea                 ecx, [ebp - 0x1318]
            //   e8????????           |                     
            //   ff30                 | push                dword ptr [eax]
            //   8d8d10e9ffff         | lea                 ecx, [ebp - 0x16f0]
            //   e8????????           |                     

        $sequence_4 = { 50 e8???????? 59 8845d4 8d45d0 50 8d45f8 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8845d4               | mov                 byte ptr [ebp - 0x2c], al
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax
            //   8d45f8               | lea                 eax, [ebp - 8]

        $sequence_5 = { 8b85ccfdffff 8b00 ffb5ccfdffff ff5024 89859cfdffff 8d8d50fdffff e8???????? }
            // n = 7, score = 100
            //   8b85ccfdffff         | mov                 eax, dword ptr [ebp - 0x234]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ffb5ccfdffff         | push                dword ptr [ebp - 0x234]
            //   ff5024               | call                dword ptr [eax + 0x24]
            //   89859cfdffff         | mov                 dword ptr [ebp - 0x264], eax
            //   8d8d50fdffff         | lea                 ecx, [ebp - 0x2b0]
            //   e8????????           |                     

        $sequence_6 = { 750a 68???????? e8???????? 8b45f0 833822 750a 68???????? }
            // n = 7, score = 100
            //   750a                 | jne                 0xc
            //   68????????           |                     
            //   e8????????           |                     
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   833822               | cmp                 dword ptr [eax], 0x22
            //   750a                 | jne                 0xc
            //   68????????           |                     

        $sequence_7 = { 817df8ff0f0000 7649 8b45f0 ff704c 68ff0f0000 6a01 ff7508 }
            // n = 7, score = 100
            //   817df8ff0f0000       | cmp                 dword ptr [ebp - 8], 0xfff
            //   7649                 | jbe                 0x4b
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   ff704c               | push                dword ptr [eax + 0x4c]
            //   68ff0f0000           | push                0xfff
            //   6a01                 | push                1
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_8 = { a1???????? 33c5 8945fc 894df0 8365e800 8b45f0 8b00 }
            // n = 7, score = 100
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   8365e800             | and                 dword ptr [ebp - 0x18], 0
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_9 = { eb9e 8d8508f8feff 50 8d8da0fbfeff e8???????? 6a01 8d8da8fcfeff }
            // n = 7, score = 100
            //   eb9e                 | jmp                 0xffffffa0
            //   8d8508f8feff         | lea                 eax, [ebp - 0x107f8]
            //   50                   | push                eax
            //   8d8da0fbfeff         | lea                 ecx, [ebp - 0x10460]
            //   e8????????           |                     
            //   6a01                 | push                1
            //   8d8da8fcfeff         | lea                 ecx, [ebp - 0x10358]

    condition:
        7 of them and filesize < 918528
}