rule win_paladin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.paladin."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.paladin"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b5d00 3bdd 7447 8d4c2414 6a00 8bc3 8b1b }
            // n = 7, score = 200
            //   8b5d00               | mov                 ebx, dword ptr [ebp]
            //   3bdd                 | cmp                 ebx, ebp
            //   7447                 | je                  0x49
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   6a00                 | push                0
            //   8bc3                 | mov                 eax, ebx
            //   8b1b                 | mov                 ebx, dword ptr [ebx]

        $sequence_1 = { 03fd ff15???????? 8b4620 85c0 7e44 33c9 8a4e1c }
            // n = 7, score = 200
            //   03fd                 | add                 edi, ebp
            //   ff15????????         |                     
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]
            //   85c0                 | test                eax, eax
            //   7e44                 | jle                 0x46
            //   33c9                 | xor                 ecx, ecx
            //   8a4e1c               | mov                 cl, byte ptr [esi + 0x1c]

        $sequence_2 = { 40 3bc6 7cf2 6a00 }
            // n = 4, score = 200
            //   40                   | inc                 eax
            //   3bc6                 | cmp                 eax, esi
            //   7cf2                 | jl                  0xfffffff4
            //   6a00                 | push                0

        $sequence_3 = { 894664 8b465c 6a00 57 8b3d???????? 6a00 }
            // n = 6, score = 200
            //   894664               | mov                 dword ptr [esi + 0x64], eax
            //   8b465c               | mov                 eax, dword ptr [esi + 0x5c]
            //   6a00                 | push                0
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   6a00                 | push                0

        $sequence_4 = { 7c02 8bc1 57 8bce 894638 e8???????? }
            // n = 6, score = 200
            //   7c02                 | jl                  4
            //   8bc1                 | mov                 eax, ecx
            //   57                   | push                edi
            //   8bce                 | mov                 ecx, esi
            //   894638               | mov                 dword ptr [esi + 0x38], eax
            //   e8????????           |                     

        $sequence_5 = { c1e004 03c2 33d2 8a11 8d04c0 8d0443 }
            // n = 6, score = 200
            //   c1e004               | shl                 eax, 4
            //   03c2                 | add                 eax, edx
            //   33d2                 | xor                 edx, edx
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   8d04c0               | lea                 eax, [eax + eax*8]
            //   8d0443               | lea                 eax, [ebx + eax*2]

        $sequence_6 = { e8???????? 8d442418 6a04 50 8bcb e8???????? 8d4c2424 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   6a04                 | push                4
            //   50                   | push                eax
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   8d4c2424             | lea                 ecx, [esp + 0x24]

        $sequence_7 = { 6a00 6880000000 6a03 6a00 6a01 8d451c 6800000080 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   6880000000           | push                0x80
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   8d451c               | lea                 eax, [ebp + 0x1c]
            //   6800000080           | push                0x80000000

        $sequence_8 = { 56 ff95a4feffff 85c0 7412 6820030000 }
            // n = 5, score = 200
            //   56                   | push                esi
            //   ff95a4feffff         | call                dword ptr [ebp - 0x15c]
            //   85c0                 | test                eax, eax
            //   7412                 | je                  0x14
            //   6820030000           | push                0x320

        $sequence_9 = { 8d69f3 55 e8???????? 8bf0 55 }
            // n = 5, score = 200
            //   8d69f3               | lea                 ebp, [ecx - 0xd]
            //   55                   | push                ebp
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   55                   | push                ebp

    condition:
        7 of them and filesize < 106496
}