rule win_parallax_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.parallax."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.parallax"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff96fc000000 6a04 68???????? 6a0a 68???????? e8???????? 6a04 }
            // n = 7, score = 200
            //   ff96fc000000         | call                dword ptr [esi + 0xfc]
            //   6a04                 | push                4
            //   68????????           |                     
            //   6a0a                 | push                0xa
            //   68????????           |                     
            //   e8????????           |                     
            //   6a04                 | push                4

        $sequence_1 = { 837d0801 7548 8d35f4ec4000 8d3d04f14000 b908020000 f3a4 6a04 }
            // n = 7, score = 200
            //   837d0801             | cmp                 dword ptr [ebp + 8], 1
            //   7548                 | jne                 0x4a
            //   8d35f4ec4000         | lea                 esi, [0x40ecf4]
            //   8d3d04f14000         | lea                 edi, [0x40f104]
            //   b908020000           | mov                 ecx, 0x208
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   6a04                 | push                4

        $sequence_2 = { ff7634 52 ff750c e8???????? 6a00 ff750c ff7508 }
            // n = 7, score = 200
            //   ff7634               | push                dword ptr [esi + 0x34]
            //   52                   | push                edx
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   e8????????           |                     
            //   6a00                 | push                0
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_3 = { 3d02800000 7510 ff7514 ff7510 e8???????? e9???????? 3d03800000 }
            // n = 7, score = 200
            //   3d02800000           | cmp                 eax, 0x8002
            //   7510                 | jne                 0x12
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   e9????????           |                     
            //   3d03800000           | cmp                 eax, 0x8003

        $sequence_4 = { 5d c20c00 55 8bec 8b7d08 }
            // n = 5, score = 200
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]

        $sequence_5 = { 5d c20800 e8???????? 5e 662bf6 8b15???????? 3315???????? }
            // n = 7, score = 200
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   e8????????           |                     
            //   5e                   | pop                 esi
            //   662bf6               | sub                 si, si
            //   8b15????????         |                     
            //   3315????????         |                     

        $sequence_6 = { 895f1c 8bc3 5f 5e 8be5 5d c20800 }
            // n = 7, score = 200
            //   895f1c               | mov                 dword ptr [edi + 0x1c], ebx
            //   8bc3                 | mov                 eax, ebx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8

        $sequence_7 = { 89463c 68ff1f0000 e8???????? 8b563c }
            // n = 4, score = 200
            //   89463c               | mov                 dword ptr [esi + 0x3c], eax
            //   68ff1f0000           | push                0x1fff
            //   e8????????           |                     
            //   8b563c               | mov                 edx, dword ptr [esi + 0x3c]

        $sequence_8 = { ff751c 8f4614 ff7520 8f461c 5d c21c00 }
            // n = 6, score = 200
            //   ff751c               | push                dword ptr [ebp + 0x1c]
            //   8f4614               | pop                 dword ptr [esi + 0x14]
            //   ff7520               | push                dword ptr [ebp + 0x20]
            //   8f461c               | pop                 dword ptr [esi + 0x1c]
            //   5d                   | pop                 ebp
            //   c21c00               | ret                 0x1c

        $sequence_9 = { 8b4648 8945f4 ff75f8 ff75f0 ff75f4 e8???????? eb28 }
            // n = 7, score = 200
            //   8b4648               | mov                 eax, dword ptr [esi + 0x48]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   e8????????           |                     
            //   eb28                 | jmp                 0x2a

    condition:
        7 of them and filesize < 352256
}