rule win_parasite_http_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.parasite_http."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.parasite_http"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c602 43 3b5df4 72e6 8b7de4 eb07 8bcf }
            // n = 7, score = 100
            //   83c602               | add                 esi, 2
            //   43                   | inc                 ebx
            //   3b5df4               | cmp                 ebx, dword ptr [ebp - 0xc]
            //   72e6                 | jb                  0xffffffe8
            //   8b7de4               | mov                 edi, dword ptr [ebp - 0x1c]
            //   eb07                 | jmp                 9
            //   8bcf                 | mov                 ecx, edi

        $sequence_1 = { ff75f4 6aff ff15???????? 5f 5e 8bc3 5b }
            // n = 7, score = 100
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   6aff                 | push                -1
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   8bc3                 | mov                 eax, ebx
            //   5b                   | pop                 ebx

        $sequence_2 = { 8d95d4fdffff c785d4fdffff2c020000 8bce e8???????? e9???????? e8???????? 8b8ddcfdffff }
            // n = 7, score = 100
            //   8d95d4fdffff         | lea                 edx, [ebp - 0x22c]
            //   c785d4fdffff2c020000     | mov    dword ptr [ebp - 0x22c], 0x22c
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   e9????????           |                     
            //   e8????????           |                     
            //   8b8ddcfdffff         | mov                 ecx, dword ptr [ebp - 0x224]

        $sequence_3 = { 85c9 7405 e8???????? 5e 8bc3 5b 5f }
            // n = 7, score = 100
            //   85c9                 | test                ecx, ecx
            //   7405                 | je                  7
            //   e8????????           |                     
            //   5e                   | pop                 esi
            //   8bc3                 | mov                 eax, ebx
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi

        $sequence_4 = { ff7508 6801000040 57 53 ffd0 f7d8 5f }
            // n = 7, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   6801000040           | push                0x40000001
            //   57                   | push                edi
            //   53                   | push                ebx
            //   ffd0                 | call                eax
            //   f7d8                 | neg                 eax
            //   5f                   | pop                 edi

        $sequence_5 = { ff7510 6aff ff7508 6a00 68e9fd0000 ffd0 5e }
            // n = 7, score = 100
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   6aff                 | push                -1
            //   ff7508               | push                dword ptr [ebp + 8]
            //   6a00                 | push                0
            //   68e9fd0000           | push                0xfde9
            //   ffd0                 | call                eax
            //   5e                   | pop                 esi

        $sequence_6 = { ff55f0 8945e0 837de000 0f84eb000000 ff75ec 6a00 ff55e8 }
            // n = 7, score = 100
            //   ff55f0               | call                dword ptr [ebp - 0x10]
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   837de000             | cmp                 dword ptr [ebp - 0x20], 0
            //   0f84eb000000         | je                  0xf1
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   6a00                 | push                0
            //   ff55e8               | call                dword ptr [ebp - 0x18]

        $sequence_7 = { e8???????? 8bd6 8bc8 e8???????? ff751c ff7518 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8bd6                 | mov                 edx, esi
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   ff751c               | push                dword ptr [ebp + 0x1c]
            //   ff7518               | push                dword ptr [ebp + 0x18]

        $sequence_8 = { 6a00 6a00 681f000f00 57 ffd0 5f 5e }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   681f000f00           | push                0xf001f
            //   57                   | push                edi
            //   ffd0                 | call                eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_9 = { 8d8df8efffff 51 ffd0 5e 85c0 7917 b9???????? }
            // n = 7, score = 100
            //   8d8df8efffff         | lea                 ecx, [ebp - 0x1008]
            //   51                   | push                ecx
            //   ffd0                 | call                eax
            //   5e                   | pop                 esi
            //   85c0                 | test                eax, eax
            //   7917                 | jns                 0x19
            //   b9????????           |                     

    condition:
        7 of them and filesize < 147456
}