rule win_pathloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pathloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pathloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7742 498bc8 e8???????? 4c897710 48c747180f000000 }
            // n = 5, score = 100
            //   7742                 | lea                 eax, [esp + 0x60]
            //   498bc8               | dec                 esp
            //   e8????????           |                     
            //   4c897710             | add                 eax, eax
            //   48c747180f000000     | nop                 dword ptr [eax]

        $sequence_1 = { 41ffd0 498986d8000000 488d55c8 48837de008 480f4355c8 4533c9 450fb786a0000000 }
            // n = 7, score = 100
            //   41ffd0               | dec                 eax
            //   498986d8000000       | mov                 eax, dword ptr [eax + 0x18]
            //   488d55c8             | dec                 eax
            //   48837de008           | mov                 eax, dword ptr [eax + 0x10]
            //   480f4355c8           | nop                 dword ptr [eax]
            //   4533c9               | mov                 dword ptr [ebp - 0x30], 0x100000
            //   450fb786a0000000     | movups              xmmword ptr [ebp - 0x70], xmm0

        $sequence_2 = { 7524 488d0d5e940200 e8???????? 85c0 7510 488d0d66940200 e8???????? }
            // n = 7, score = 100
            //   7524                 | je                  0x126
            //   488d0d5e940200       | dec                 eax
            //   e8????????           |                     
            //   85c0                 | lea                 ecx, [0x9d1]
            //   7510                 | mov                 ecx, eax
            //   488d0d66940200       | je                  0x132
            //   e8????????           |                     

        $sequence_3 = { 488d15ea240100 e8???????? 8bcb 4885c0 740c }
            // n = 5, score = 100
            //   488d15ea240100       | dec                 eax
            //   e8????????           |                     
            //   8bcb                 | sub                 esp, 0x20
            //   4885c0               | dec                 eax
            //   740c                 | mov                 ebx, ecx

        $sequence_4 = { 0fb705???????? 6689442460 0fb605???????? 88442462 448bc1 4183ff02 }
            // n = 6, score = 100
            //   0fb705????????       |                     
            //   6689442460           | dec                 ecx
            //   0fb605????????       |                     
            //   88442462             | mov                 dword ptr [ebx + 0x18], ebp
            //   448bc1               | dec                 ecx
            //   4183ff02             | mov                 dword ptr [ebx + 0x20], esi

        $sequence_5 = { 4c63d2 488bd9 498bc2 458bf1 48c1f806 488d0dc0a20100 }
            // n = 6, score = 100
            //   4c63d2               | je                  0xd0c
            //   488bd9               | inc                 esp
            //   498bc2               | mov                 edx, dword ptr [ebp + 0x18]
            //   458bf1               | inc                 ebp
            //   48c1f806             | test                edx, edx
            //   488d0dc0a20100       | inc                 edx

        $sequence_6 = { 57 4883ec20 e8???????? 488b05???????? 488d1d2ffe0100 4885c0 480f45d8 }
            // n = 7, score = 100
            //   57                   | test                edx, edx
            //   4883ec20             | je                  0x12fe
            //   e8????????           |                     
            //   488b05????????       |                     
            //   488d1d2ffe0100       | rol                 byte ptr [ebp + 0x1d840fc0], 1
            //   4885c0               | add                 al, byte ptr [eax]
            //   480f45d8             | add                 byte ptr [ebp - 0x75], cl

        $sequence_7 = { 488bfa 488bd9 49894ba8 498953b0 4533f6 45897398 }
            // n = 6, score = 100
            //   488bfa               | jne                 0x59c
            //   488bd9               | inc                 ecx
            //   49894ba8             | cmp                 edx, 0x14868507
            //   498953b0             | je                  0x5de
            //   4533f6               | inc                 ecx
            //   45897398             | xor                 edx, edx

        $sequence_8 = { 410fb641ff 440f47c2 4533c2 4569d093010001 84c0 75d7 4181fad26d58ad }
            // n = 7, score = 100
            //   410fb641ff           | nop                 dword ptr [eax]
            //   440f47c2             | nop                 dword ptr [eax + eax]
            //   4533c2               | inc                 cx
            //   4569d093010001       | movd                mm2, eax
            //   84c0                 | movdqa              xmmword ptr [esp + 0x30], xmm0
            //   75d7                 | dec                 eax
            //   4181fad26d58ad       | lea                 ecx, [esp + 0x6c]

        $sequence_9 = { e8???????? 84c0 0f8422ffffff 44383d???????? f20f1005???????? 0fb705???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   84c0                 | test                edx, edx
            //   0f8422ffffff         | dec                 eax
            //   44383d????????       |                     
            //   f20f1005????????     |                     
            //   0fb705????????       |                     

    condition:
        7 of them and filesize < 464896
}