rule win_pathwiper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pathwiper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pathwiper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c78540ffffff00000000 c78544ffffff0f000000 c68530ffffff00 8d8d88ebffff e8???????? 8bf8 6a00 }
            // n = 7, score = 100
            //   c78540ffffff00000000     | mov    dword ptr [ebp - 0xc0], 0
            //   c78544ffffff0f000000     | mov    dword ptr [ebp - 0xbc], 0xf
            //   c68530ffffff00       | mov                 byte ptr [ebp - 0xd0], 0
            //   8d8d88ebffff         | lea                 ecx, [ebp - 0x1478]
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   6a00                 | push                0

        $sequence_1 = { 84c0 0f84a8000000 807d3400 0f849e000000 8b950cfeffff 8b8d04feffff 8d4201 }
            // n = 7, score = 100
            //   84c0                 | test                al, al
            //   0f84a8000000         | je                  0xae
            //   807d3400             | cmp                 byte ptr [ebp + 0x34], 0
            //   0f849e000000         | je                  0xa4
            //   8b950cfeffff         | mov                 edx, dword ptr [ebp - 0x1f4]
            //   8b8d04feffff         | mov                 ecx, dword ptr [ebp - 0x1fc]
            //   8d4201               | lea                 eax, [edx + 1]

        $sequence_2 = { 8845eb 8bc1 f7e6 6a00 68ffffff7f 52 50 }
            // n = 7, score = 100
            //   8845eb               | mov                 byte ptr [ebp - 0x15], al
            //   8bc1                 | mov                 eax, ecx
            //   f7e6                 | mul                 esi
            //   6a00                 | push                0
            //   68ffffff7f           | push                0x7fffffff
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_3 = { 8bf8 eb02 33ff 8b8518feffff 40 897dc0 50 }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   eb02                 | jmp                 4
            //   33ff                 | xor                 edi, edi
            //   8b8518feffff         | mov                 eax, dword ptr [ebp - 0x1e8]
            //   40                   | inc                 eax
            //   897dc0               | mov                 dword ptr [ebp - 0x40], edi
            //   50                   | push                eax

        $sequence_4 = { c645fc8a 50 8d8df3efffff e8???????? 8d85acf8ffff c645fc8b 50 }
            // n = 7, score = 100
            //   c645fc8a             | mov                 byte ptr [ebp - 4], 0x8a
            //   50                   | push                eax
            //   8d8df3efffff         | lea                 ecx, [ebp - 0x100d]
            //   e8????????           |                     
            //   8d85acf8ffff         | lea                 eax, [ebp - 0x754]
            //   c645fc8b             | mov                 byte ptr [ebp - 4], 0x8b
            //   50                   | push                eax

        $sequence_5 = { 3bf8 0f84f2010000 83c704 0f1f00 6a00 8d850cffffff 8bcf }
            // n = 7, score = 100
            //   3bf8                 | cmp                 edi, eax
            //   0f84f2010000         | je                  0x1f8
            //   83c704               | add                 edi, 4
            //   0f1f00               | nop                 dword ptr [eax]
            //   6a00                 | push                0
            //   8d850cffffff         | lea                 eax, [ebp - 0xf4]
            //   8bcf                 | mov                 ecx, edi

        $sequence_6 = { e8???????? 83c408 83c718 3bbd48feffff 0f85c2feffff 8d8554feffff 898528feffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   83c718               | add                 edi, 0x18
            //   3bbd48feffff         | cmp                 edi, dword ptr [ebp - 0x1b8]
            //   0f85c2feffff         | jne                 0xfffffec8
            //   8d8554feffff         | lea                 eax, [ebp - 0x1ac]
            //   898528feffff         | mov                 dword ptr [ebp - 0x1d8], eax

        $sequence_7 = { 660fd68504f0ffff c785f4efffff3734d6f2 0f1f440000 8a443dd0 32c1 88843df8efffff }
            // n = 6, score = 100
            //   660fd68504f0ffff     | movq                qword ptr [ebp - 0xffc], xmm0
            //   c785f4efffff3734d6f2     | mov    dword ptr [ebp - 0x100c], 0xf2d63437
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   8a443dd0             | mov                 al, byte ptr [ebp + edi - 0x30]
            //   32c1                 | xor                 al, cl
            //   88843df8efffff       | mov                 byte ptr [ebp + edi - 0x1008], al

        $sequence_8 = { 2b85bcf6ffff 8985d8f6ffff 0f8559fcffff 8b8db8f6ffff 85c9 7445 8b3c8d7c2d4600 }
            // n = 7, score = 100
            //   2b85bcf6ffff         | sub                 eax, dword ptr [ebp - 0x944]
            //   8985d8f6ffff         | mov                 dword ptr [ebp - 0x928], eax
            //   0f8559fcffff         | jne                 0xfffffc5f
            //   8b8db8f6ffff         | mov                 ecx, dword ptr [ebp - 0x948]
            //   85c9                 | test                ecx, ecx
            //   7445                 | je                  0x47
            //   8b3c8d7c2d4600       | mov                 edi, dword ptr [ecx*4 + 0x462d7c]

        $sequence_9 = { 8b7508 8d45f4 683734daf3 50 8d45e0 8975ec 50 }
            // n = 7, score = 100
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   683734daf3           | push                0xf3da3437
            //   50                   | push                eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   8975ec               | mov                 dword ptr [ebp - 0x14], esi
            //   50                   | push                eax

    condition:
        7 of them and filesize < 1047552
}