rule win_pay2key_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pay2key."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pay2key"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c707???????? 5f 5e 8be5 5d c3 c6470400 }
            // n = 7, score = 300
            //   c707????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   c6470400             | mov                 byte ptr [edi + 4], 0

        $sequence_1 = { 0f8412000000 83a50ce6fffffe 8b8dfce5ffff e9???????? c3 }
            // n = 5, score = 300
            //   0f8412000000         | je                  0x18
            //   83a50ce6fffffe       | and                 dword ptr [ebp - 0x19f4], 0xfffffffe
            //   8b8dfce5ffff         | mov                 ecx, dword ptr [ebp - 0x1a04]
            //   e9????????           |                     
            //   c3                   | ret                 

        $sequence_2 = { c60000 8d4540 6a00 50 e8???????? 83ec18 c645fc05 }
            // n = 7, score = 300
            //   c60000               | mov                 byte ptr [eax], 0
            //   8d4540               | lea                 eax, [ebp + 0x40]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83ec18               | sub                 esp, 0x18
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5

        $sequence_3 = { 8bce ff5004 8b45f0 8b4d0c 8907 8b4514 895f04 }
            // n = 7, score = 300
            //   8bce                 | mov                 ecx, esi
            //   ff5004               | call                dword ptr [eax + 4]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8907                 | mov                 dword ptr [edi], eax
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   895f04               | mov                 dword ptr [edi + 4], ebx

        $sequence_4 = { 8d4e34 c645fc09 c741140f000000 c7411000000000 83791410 7204 8b01 }
            // n = 7, score = 300
            //   8d4e34               | lea                 ecx, [esi + 0x34]
            //   c645fc09             | mov                 byte ptr [ebp - 4], 9
            //   c741140f000000       | mov                 dword ptr [ecx + 0x14], 0xf
            //   c7411000000000       | mov                 dword ptr [ecx + 0x10], 0
            //   83791410             | cmp                 dword ptr [ecx + 0x14], 0x10
            //   7204                 | jb                  6
            //   8b01                 | mov                 eax, dword ptr [ecx]

        $sequence_5 = { 8db758030000 8b4614 83f808 720b 40 8bce 50 }
            // n = 7, score = 300
            //   8db758030000         | lea                 esi, [edi + 0x358]
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   83f808               | cmp                 eax, 8
            //   720b                 | jb                  0xd
            //   40                   | inc                 eax
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax

        $sequence_6 = { c7411000000000 8b4114 894754 c7411400000000 8b5d10 c745fc00000000 8b0b }
            // n = 7, score = 300
            //   c7411000000000       | mov                 dword ptr [ecx + 0x10], 0
            //   8b4114               | mov                 eax, dword ptr [ecx + 0x14]
            //   894754               | mov                 dword ptr [edi + 0x54], eax
            //   c7411400000000       | mov                 dword ptr [ecx + 0x14], 0
            //   8b5d10               | mov                 ebx, dword ptr [ebp + 0x10]
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8b0b                 | mov                 ecx, dword ptr [ebx]

        $sequence_7 = { c745fc01000000 8b4de0 85c9 7414 8b01 8b4010 ffd0 }
            // n = 7, score = 300
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   85c9                 | test                ecx, ecx
            //   7414                 | je                  0x16
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]
            //   ffd0                 | call                eax

        $sequence_8 = { 8886b2000000 c686b300000001 c7411407000000 c7411000000000 83791408 7204 8b01 }
            // n = 7, score = 300
            //   8886b2000000         | mov                 byte ptr [esi + 0xb2], al
            //   c686b300000001       | mov                 byte ptr [esi + 0xb3], 1
            //   c7411407000000       | mov                 dword ptr [ecx + 0x14], 7
            //   c7411000000000       | mov                 dword ptr [ecx + 0x10], 0
            //   83791408             | cmp                 dword ptr [ecx + 0x14], 8
            //   7204                 | jb                  6
            //   8b01                 | mov                 eax, dword ptr [ecx]

        $sequence_9 = { c645fc01 8d45a8 6a00 50 8d4dd8 c745ec0f000000 c745e800000000 }
            // n = 7, score = 300
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   8d45a8               | lea                 eax, [ebp - 0x58]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   c745ec0f000000       | mov                 dword ptr [ebp - 0x14], 0xf
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0

    condition:
        7 of them and filesize < 2252800
}