rule win_phandoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.phandoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.phandoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b36 e8???????? 83c404 eb25 e8???????? }
            // n = 5, score = 800
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   eb25                 | jmp                 0x27
            //   e8????????           |                     

        $sequence_1 = { ffd6 833d????????00 a3???????? 0f8482000000 833d????????00 7479 833d????????00 }
            // n = 7, score = 800
            //   ffd6                 | call                esi
            //   833d????????00       |                     
            //   a3????????           |                     
            //   0f8482000000         | je                  0x88
            //   833d????????00       |                     
            //   7479                 | je                  0x7b
            //   833d????????00       |                     

        $sequence_2 = { 83c418 803f53 755f 807f015e }
            // n = 4, score = 800
            //   83c418               | add                 esp, 0x18
            //   803f53               | cmp                 byte ptr [edi], 0x53
            //   755f                 | jne                 0x61
            //   807f015e             | cmp                 byte ptr [edi + 1], 0x5e

        $sequence_3 = { 8bd8 c1eb08 8bd1 895df8 8bd9 c1ea08 }
            // n = 6, score = 800
            //   8bd8                 | mov                 ebx, eax
            //   c1eb08               | shr                 ebx, 8
            //   8bd1                 | mov                 edx, ecx
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   8bd9                 | mov                 ebx, ecx
            //   c1ea08               | shr                 edx, 8

        $sequence_4 = { 22da 22d9 8bc8 c1e910 224df8 }
            // n = 5, score = 800
            //   22da                 | and                 bl, dl
            //   22d9                 | and                 bl, cl
            //   8bc8                 | mov                 ecx, eax
            //   c1e910               | shr                 ecx, 0x10
            //   224df8               | and                 cl, byte ptr [ebp - 8]

        $sequence_5 = { 890d???????? 8b96bc010000 8915???????? 33ff 399e90010000 763b }
            // n = 6, score = 800
            //   890d????????         |                     
            //   8b96bc010000         | mov                 edx, dword ptr [esi + 0x1bc]
            //   8915????????         |                     
            //   33ff                 | xor                 edi, edi
            //   399e90010000         | cmp                 dword ptr [esi + 0x190], ebx
            //   763b                 | jbe                 0x3d

        $sequence_6 = { e8???????? 8b1d???????? 50 ffd3 8bf8 3bfe 8b35???????? }
            // n = 7, score = 800
            //   e8????????           |                     
            //   8b1d????????         |                     
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   8bf8                 | mov                 edi, eax
            //   3bfe                 | cmp                 edi, esi
            //   8b35????????         |                     

        $sequence_7 = { 0f8438010000 833d????????00 0f842b010000 833d????????00 0f841e010000 833d????????00 0f8411010000 }
            // n = 7, score = 800
            //   0f8438010000         | je                  0x13e
            //   833d????????00       |                     
            //   0f842b010000         | je                  0x131
            //   833d????????00       |                     
            //   0f841e010000         | je                  0x124
            //   833d????????00       |                     
            //   0f8411010000         | je                  0x117

        $sequence_8 = { 741c 8b0d???????? 68???????? 51 c705????????04000000 }
            // n = 5, score = 500
            //   741c                 | je                  0x1e
            //   8b0d????????         |                     
            //   68????????           |                     
            //   51                   | push                ecx
            //   c705????????04000000     |     

        $sequence_9 = { 83c404 8bf7 85ff 75e6 5f c7430800000000 }
            // n = 6, score = 500
            //   83c404               | add                 esp, 4
            //   8bf7                 | mov                 esi, edi
            //   85ff                 | test                edi, edi
            //   75e6                 | jne                 0xffffffe8
            //   5f                   | pop                 edi
            //   c7430800000000       | mov                 dword ptr [ebx + 8], 0

        $sequence_10 = { 43 84c0 7409 8803 }
            // n = 4, score = 500
            //   43                   | inc                 ebx
            //   84c0                 | test                al, al
            //   7409                 | je                  0xb
            //   8803                 | mov                 byte ptr [ebx], al

        $sequence_11 = { 6a03 d1ea 8d85e8efffff e8???????? }
            // n = 4, score = 500
            //   6a03                 | push                3
            //   d1ea                 | shr                 edx, 1
            //   8d85e8efffff         | lea                 eax, [ebp - 0x1018]
            //   e8????????           |                     

        $sequence_12 = { 741c 56 8b35???????? 3acb 740e }
            // n = 5, score = 500
            //   741c                 | je                  0x1e
            //   56                   | push                esi
            //   8b35????????         |                     
            //   3acb                 | cmp                 cl, bl
            //   740e                 | je                  0x10

        $sequence_13 = { 3acb 740e 50 ffd6 }
            // n = 4, score = 500
            //   3acb                 | cmp                 cl, bl
            //   740e                 | je                  0x10
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_14 = { 6a03 d1ea 8bc3 e8???????? 8bc8 85c9 }
            // n = 6, score = 500
            //   6a03                 | push                3
            //   d1ea                 | shr                 edx, 1
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   85c9                 | test                ecx, ecx

        $sequence_15 = { 57 68???????? 50 c705????????03000000 ffd6 8b0d???????? 33ff }
            // n = 7, score = 500
            //   57                   | push                edi
            //   68????????           |                     
            //   50                   | push                eax
            //   c705????????03000000     |     
            //   ffd6                 | call                esi
            //   8b0d????????         |                     
            //   33ff                 | xor                 edi, edi

    condition:
        7 of them and filesize < 2124800
}