rule win_phobos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.phobos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.phobos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4f ff75fc e8???????? 59 8bc7 5f 5e }
            // n = 7, score = 100
            //   4f                   | dec                 edi
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_1 = { 6a0c 5b 53 8d442430 56 50 e8???????? }
            // n = 7, score = 100
            //   6a0c                 | push                0xc
            //   5b                   | pop                 ebx
            //   53                   | push                ebx
            //   8d442430             | lea                 eax, [esp + 0x30]
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_2 = { 7446 8b06 85c0 7440 8b0f 894e04 8b4f04 }
            // n = 7, score = 100
            //   7446                 | je                  0x48
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   85c0                 | test                eax, eax
            //   7440                 | je                  0x42
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   894e04               | mov                 dword ptr [esi + 4], ecx
            //   8b4f04               | mov                 ecx, dword ptr [edi + 4]

        $sequence_3 = { 33db 56 57 33c0 895c2428 8d7c242c ab }
            // n = 7, score = 100
            //   33db                 | xor                 ebx, ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33c0                 | xor                 eax, eax
            //   895c2428             | mov                 dword ptr [esp + 0x28], ebx
            //   8d7c242c             | lea                 edi, [esp + 0x2c]
            //   ab                   | stosd               dword ptr es:[edi], eax

        $sequence_4 = { 8bc6 8d3c08 8d8fb2000000 894df4 83c118 2bc8 81c100000400 }
            // n = 7, score = 100
            //   8bc6                 | mov                 eax, esi
            //   8d3c08               | lea                 edi, [eax + ecx]
            //   8d8fb2000000         | lea                 ecx, [edi + 0xb2]
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   83c118               | add                 ecx, 0x18
            //   2bc8                 | sub                 ecx, eax
            //   81c100000400         | add                 ecx, 0x40000

        $sequence_5 = { 5b c9 c3 56 6a1c }
            // n = 5, score = 100
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c3                   | ret                 
            //   56                   | push                esi
            //   6a1c                 | push                0x1c

        $sequence_6 = { 83c002 eb02 8bc7 8bc8 56 8d7102 }
            // n = 6, score = 100
            //   83c002               | add                 eax, 2
            //   eb02                 | jmp                 4
            //   8bc7                 | mov                 eax, edi
            //   8bc8                 | mov                 ecx, eax
            //   56                   | push                esi
            //   8d7102               | lea                 esi, [ecx + 2]

        $sequence_7 = { 68ff000000 ff15???????? cc 55 8bec 8b4508 a3???????? }
            // n = 7, score = 100
            //   68ff000000           | push                0xff
            //   ff15????????         |                     
            //   cc                   | int3                
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   a3????????           |                     

        $sequence_8 = { 0f8452010000 3bf7 7420 8d44243c 50 ff15???????? 50 }
            // n = 7, score = 100
            //   0f8452010000         | je                  0x158
            //   3bf7                 | cmp                 esi, edi
            //   7420                 | je                  0x22
            //   8d44243c             | lea                 eax, [esp + 0x3c]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_9 = { ff7708 8d442430 ff7704 ff37 50 56 e8???????? }
            // n = 7, score = 100
            //   ff7708               | push                dword ptr [edi + 8]
            //   8d442430             | lea                 eax, [esp + 0x30]
            //   ff7704               | push                dword ptr [edi + 4]
            //   ff37                 | push                dword ptr [edi]
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     

    condition:
        7 of them and filesize < 139264
}