rule win_phoenix_locker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.phoenix_locker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.phoenix_locker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffc3 4d0fbfd0 66450fbed2 450fbfd5 4c63d3 e9???????? e9???????? }
            // n = 7, score = 200
            //   ffc3                 | arpl                bx, si
            //   4d0fbfd0             | xchg                si, si
            //   66450fbed2           | dec                 eax
            //   450fbfd5             | cmovo               esi, ebp
            //   4c63d3               | test                edx, 0x18351d30
            //   e9????????           |                     
            //   e9????????           |                     

        $sequence_1 = { 0f8774000000 0f8530000000 488b542428 480fb7cd 488d4b14 e9???????? ff15???????? }
            // n = 7, score = 200
            //   0f8774000000         | add                 dword ptr [ebp + 0x64f15b65], ebp
            //   0f8530000000         | outsb               dx, byte ptr [esi]
            //   488b542428           | mov                 dword ptr ds:[0xb5632c0e], eax
            //   480fb7cd             | pop                 edx
            //   488d4b14             | int1                
            //   e9????????           |                     
            //   ff15????????         |                     

        $sequence_2 = { 41b07c 6644896c2420 480fabc8 48ffc8 4180d05d 488d542420 }
            // n = 6, score = 200
            //   41b07c               | movsx               edx, ah
            //   6644896c2420         | dec                 ebp
            //   480fabc8             | movsx               edx, bx
            //   48ffc8               | pushfd              
            //   4180d05d             | inc                 bp
            //   488d542420           | movzx               edx, cl

        $sequence_3 = { 4586c0 4c8bc2 f7d2 488bd1 488d0de21fe5ff e8???????? 488d0dd61fe5ff }
            // n = 7, score = 200
            //   4586c0               | test                edx, ebx
            //   4c8bc2               | cmp                 word ptr [edi + 0x40], 0x2e
            //   f7d2                 | mov                 dword ptr [esp + 0x60], ecx
            //   488bd1               | inc                 esp
            //   488d0de21fe5ff       | cmp                 ah, ah
            //   e8????????           |                     
            //   488d0dd61fe5ff       | stc                 

        $sequence_4 = { 4184eb f9 4c03d1 4d8d1c0b f8 41f6c484 4585c9 }
            // n = 7, score = 200
            //   4184eb               | inc                 ecx
            //   f9                   | movzx               ecx, byte ptr [ebp + eax*4]
            //   4c03d1               | inc                 cx
            //   4d8d1c0b             | bsr                 edx, edi
            //   f8                   | inc                 ecx
            //   41f6c484             | movzx               eax, bl
            //   4585c9               | dec                 eax

        $sequence_5 = { 688c4bd073 0f82f8aefeff 48818424100000006c322f5a 5e 5e 5e }
            // n = 6, score = 200
            //   688c4bd073           | inc                 ecx
            //   0f82f8aefeff         | push                esi
            //   48818424100000006c322f5a     | inc    bp
            //   5e                   | movzx               edx, dl
            //   5e                   | popfd               
            //   5e                   | pop                 eax

        $sequence_6 = { 418b0c84 98 23cd 660fb6c6 4433c1 98 4633048b }
            // n = 7, score = 200
            //   418b0c84             | movsx               eax, si
            //   98                   | inc                 esp
            //   23cd                 | mov                 byte ptr [esp + 0x40], bl
            //   660fb6c6             | neg                 ax
            //   4433c1               | mov                 dword ptr [esp + 0x38], 1
            //   98                   | inc                 ecx
            //   4633048b             | mov                 al, bl

        $sequence_7 = { e9???????? 0f84c0000000 418d5424ff 6641f7c2266e 4c0fa4cfaa 4c8bed }
            // n = 6, score = 200
            //   e9????????           |                     
            //   0f84c0000000         | sal                 al, 0xe9
            //   418d5424ff           | dec                 eax
            //   6641f7c2266e         | shl                 eax, cl
            //   4c0fa4cfaa           | inc                 ecx
            //   4c8bed               | lea                 eax, [ecx - 1]

        $sequence_8 = { 55 d9b726ae0b68 a947d046d6 5b 21bd5e13d92f 5a 81e516495a66 }
            // n = 7, score = 200
            //   55                   | inc                 eax
            //   d9b726ae0b68         | sub                 edx, edx
            //   a947d046d6           | dec                 esp
            //   5b                   | lea                 eax, [ebx + ebx]
            //   21bd5e13d92f         | mov                 esi, ebx
            //   5a                   | dec                 esp
            //   81e516495a66         | arpl                bp, ax

        $sequence_9 = { f5 f69c2418000000 5f 415e 415e 415e 5f }
            // n = 7, score = 200
            //   f5                   | inc                 ecx
            //   f69c2418000000       | dec                 ebx
            //   5f                   | shr                 eax, cl
            //   415e                 | test                ecx, ecx
            //   415e                 | je                  0xdb0
            //   415e                 | inc                 ecx
            //   5f                   | cmp                 eax, esi

    condition:
        7 of them and filesize < 3702784
}