rule win_phoreal_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.phoreal."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.phoreal"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33ff 8d642400 8b4608 3b7e0c 731f 8b0cb8 8d04b8 }
            // n = 7, score = 200
            //   33ff                 | xor                 edi, edi
            //   8d642400             | lea                 esp, [esp]
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   3b7e0c               | cmp                 edi, dword ptr [esi + 0xc]
            //   731f                 | jae                 0x21
            //   8b0cb8               | mov                 ecx, dword ptr [eax + edi*4]
            //   8d04b8               | lea                 eax, [eax + edi*4]

        $sequence_1 = { 8bd0 0355f8 83c40c 2bf7 740b 8bce 33c0 }
            // n = 7, score = 200
            //   8bd0                 | mov                 edx, eax
            //   0355f8               | add                 edx, dword ptr [ebp - 8]
            //   83c40c               | add                 esp, 0xc
            //   2bf7                 | sub                 esi, edi
            //   740b                 | je                  0xd
            //   8bce                 | mov                 ecx, esi
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 8d45ac 50 51 53 ffd6 85c0 750a }
            // n = 7, score = 200
            //   8d45ac               | lea                 eax, [ebp - 0x54]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc

        $sequence_3 = { 2bf0 03f8 85f6 7fe0 eb03 83cfff }
            // n = 6, score = 200
            //   2bf0                 | sub                 esi, eax
            //   03f8                 | add                 edi, eax
            //   85f6                 | test                esi, esi
            //   7fe0                 | jg                  0xffffffe2
            //   eb03                 | jmp                 5
            //   83cfff               | or                  edi, 0xffffffff

        $sequence_4 = { 2bc1 50 51 8d45cc 50 53 }
            // n = 6, score = 200
            //   2bc1                 | sub                 eax, ecx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_5 = { 51 c7852cfeffff01000000 888534feffff e8???????? 8d8554ffffff 33d2 8d7e17 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   c7852cfeffff01000000     | mov    dword ptr [ebp - 0x1d4], 1
            //   888534feffff         | mov                 byte ptr [ebp - 0x1cc], al
            //   e8????????           |                     
            //   8d8554ffffff         | lea                 eax, [ebp - 0xac]
            //   33d2                 | xor                 edx, edx
            //   8d7e17               | lea                 edi, [esi + 0x17]

        $sequence_6 = { 1bd2 f7d2 85d1 75c3 8b5c2414 33ff 8b4c2418 }
            // n = 7, score = 200
            //   1bd2                 | sbb                 edx, edx
            //   f7d2                 | not                 edx
            //   85d1                 | test                ecx, edx
            //   75c3                 | jne                 0xffffffc5
            //   8b5c2414             | mov                 ebx, dword ptr [esp + 0x14]
            //   33ff                 | xor                 edi, edi
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]

        $sequence_7 = { 8b0d???????? 8b55fc 8d040f 2bf0 03f1 c1fe02 }
            // n = 6, score = 200
            //   8b0d????????         |                     
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8d040f               | lea                 eax, [edi + ecx]
            //   2bf0                 | sub                 esi, eax
            //   03f1                 | add                 esi, ecx
            //   c1fe02               | sar                 esi, 2

        $sequence_8 = { c78574ffffff8992f2a7 c78578ffffffaa9e9aee c7857cffffff89a5c199 c7458067cc6aaf c74584fa1200f5 c74588efc8d4ba }
            // n = 6, score = 200
            //   c78574ffffff8992f2a7     | mov    dword ptr [ebp - 0x8c], 0xa7f29289
            //   c78578ffffffaa9e9aee     | mov    dword ptr [ebp - 0x88], 0xee9a9eaa
            //   c7857cffffff89a5c199     | mov    dword ptr [ebp - 0x84], 0x99c1a589
            //   c7458067cc6aaf       | mov                 dword ptr [ebp - 0x80], 0xaf6acc67
            //   c74584fa1200f5       | mov                 dword ptr [ebp - 0x7c], 0xf50012fa
            //   c74588efc8d4ba       | mov                 dword ptr [ebp - 0x78], 0xbad4c8ef

        $sequence_9 = { 85ff 7414 8b855cffffff 50 }
            // n = 4, score = 200
            //   85ff                 | test                edi, edi
            //   7414                 | je                  0x16
            //   8b855cffffff         | mov                 eax, dword ptr [ebp - 0xa4]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 622592
}