rule win_photofork_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.photofork."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.photofork"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4d85d2 7515 8d56fc 33c9 41b8fe6a7a69 e8???????? }
            // n = 6, score = 400
            //   4d85d2               | cmp                 ecx, 3
            //   7515                 | nop                 dword ptr [eax]
            //   8d56fc               | mov                 eax, dword ptr [esp + ecx*4 + 0x34]
            //   33c9                 | xor                 eax, 0x5668698d
            //   41b8fe6a7a69         | mov                 dword ptr [esp + ecx*4 + 0x34], eax
            //   e8????????           |                     

        $sequence_1 = { 4156 4883ec60 49894ba8 4533e4 }
            // n = 4, score = 400
            //   4156                 | dec                 eax
            //   4883ec60             | inc                 ecx
            //   49894ba8             | dec                 eax
            //   4533e4               | cmp                 ecx, 5

        $sequence_2 = { 488b0d???????? 488981e0100000 eb12 ba01000000 }
            // n = 4, score = 400
            //   488b0d????????       |                     
            //   488981e0100000       | mov                 byte ptr [ecx], 0
            //   eb12                 | dec                 eax
            //   ba01000000           | add                 edi, ecx

        $sequence_3 = { 4c894858 33d2 41b800800000 488bcf 41ffd1 33c0 4881c4a0000000 }
            // n = 7, score = 400
            //   4c894858             | movzx               eax, byte ptr [ebp - 0x49]
            //   33d2                 | dec                 esp
            //   41b800800000         | sub                 eax, edx
            //   488bcf               | dec                 ecx
            //   41ffd1               | shr                 eax, 1
            //   33c0                 | dec                 esp
            //   4881c4a0000000       | add                 eax, edx

        $sequence_4 = { 4c8d45c4 eb72 488b05???????? 4885c0 742c 488b8080010000 }
            // n = 6, score = 400
            //   4c8d45c4             | dec                 eax
            //   eb72                 | test                edi, edi
            //   488b05????????       |                     
            //   4885c0               | je                  0x168
            //   742c                 | call                eax
            //   488b8080010000       | jmp                 0x194

        $sequence_5 = { 0f85b9010000 ff15???????? 83f87a 0f85aa010000 8b8424d0000000 }
            // n = 5, score = 400
            //   0f85b9010000         | dec                 eax
            //   ff15????????         |                     
            //   83f87a               | inc                 edi
            //   0f85aa010000         | mov                 eax, dword ptr [ebp + edi*4 - 0x18]
            //   8b8424d0000000       | xor                 eax, 0x28b86672

        $sequence_6 = { 5e 5d c3 498bdf 6690 80bbc001000030 }
            // n = 6, score = 400
            //   5e                   | mov                 eax, dword ptr [esp + ecx*4 + 0x54]
            //   5d                   | xor                 eax, 0xc139165
            //   c3                   | mov                 dword ptr [esp + ecx*4 + 0x54], eax
            //   498bdf               | dec                 eax
            //   6690                 | inc                 ecx
            //   80bbc001000030       | nop                 dword ptr [eax]

        $sequence_7 = { 4c8bc6 488d950c020000 e8???????? 488d5590 }
            // n = 4, score = 400
            //   4c8bc6               | dec                 ecx
            //   488d950c020000       | div                 esi
            //   e8????????           |                     
            //   488d5590             | mov                 dword ptr [ebp + 0xf], 0x43084527

        $sequence_8 = { 488bd0 488b05???????? 48899040060000 488d4dc0 ffd2 66837dc009 b840000000 }
            // n = 7, score = 400
            //   488bd0               | mov                 eax, dword ptr [esp + 0x30]
            //   488b05????????       |                     
            //   48899040060000       | mov                 byte ptr [esp + 0x30], bl
            //   488d4dc0             | mov                 dword ptr [esp + 0x34], 0x223e5b9d
            //   ffd2                 | mov                 dword ptr [esp + 0x38], 0x220f5bbe
            //   66837dc009           | mov                 eax, dword ptr [esp + 0x34]
            //   b840000000           | movzx               eax, byte ptr [esp + 0x30]

        $sequence_9 = { 72ea 4533c9 4c8d459c 488d54242c }
            // n = 4, score = 400
            //   72ea                 | test                ax, ax
            //   4533c9               | dec                 eax
            //   4c8d459c             | lea                 edx, [esp + 0x20]
            //   488d54242c           | xorps               xmm0, xmm0

    condition:
        7 of them and filesize < 99328
}