rule win_photolite_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.photolite."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.photolite"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4883f905 72e4 889db4010000 ba7e32f11a c785b801000035578374 }
            // n = 5, score = 400
            //   4883f905             | dec                 eax
            //   72e4                 | cmp                 ecx, 5
            //   889db4010000         | jb                  0xffffffe6
            //   ba7e32f11a           | mov                 byte ptr [ebp + 0x1b4], bl
            //   c785b801000035578374     | mov    edx, 0x1af1327e

        $sequence_1 = { 4803cf 493bce 72e8 889d2c010000 c78530010000d857fc49 }
            // n = 5, score = 400
            //   4803cf               | lea                 ebp, [eax - 0x6a8]
            //   493bce               | dec                 eax
            //   72e8                 | sub                 esp, 0x7a0
            //   889d2c010000         | xor                 ebx, ebx
            //   c78530010000d857fc49     | dec    eax

        $sequence_2 = { c785e4020000b434516d c785e8020000813e467c c785ec02000097355758 c785f00200008022253d }
            // n = 4, score = 400
            //   c785e4020000b434516d     | mov    dword ptr [ebp + 0x1b8], 0x74835735
            //   c785e8020000813e467c     | mov    dword ptr [ebp + 0x2e4], 0x6d5134b4
            //   c785ec02000097355758     | mov    dword ptr [ebp + 0x2e8], 0x7c463e81
            //   c785f00200008022253d     | mov    dword ptr [ebp + 0x2ec], 0x58573597

        $sequence_3 = { 4c897020 55 488da858f9ffff 4881eca0070000 33db }
            // n = 5, score = 400
            //   4c897020             | mov                 dword ptr [ebp + 0x3dc], 0x2eedf3d1
            //   55                   | dec                 esp
            //   488da858f9ffff       | mov                 dword ptr [eax + 0x20], esi
            //   4881eca0070000       | push                ebp
            //   33db                 | dec                 eax

        $sequence_4 = { c78568040000bb4e5450 c7856c040000a94d1c35 8b8560040000 8a855c040000 }
            // n = 4, score = 400
            //   c78568040000bb4e5450     | add    ecx, edi
            //   c7856c040000a94d1c35     | dec    ecx
            //   8b8560040000         | cmp                 ecx, esi
            //   8a855c040000         | jb                  0xffffffed

        $sequence_5 = { c78530060000a8eeaa04 c78534060000a8fbc56a 8b8520060000 8a851c060000 }
            // n = 4, score = 400
            //   c78530060000a8eeaa04     | mov    dword ptr [ebp + 0x630], 0x4aaeea8
            //   c78534060000a8fbc56a     | mov    dword ptr [ebp + 0x634], 0x6ac5fba8
            //   8b8520060000         | mov                 eax, dword ptr [ebp + 0x620]
            //   8a851c060000         | mov                 al, byte ptr [ebp + 0x61c]

        $sequence_6 = { 72e8 889dd0030000 baff978142 c785d403000094f2f32c c785d80300009afbb270 c785dc030000d1f3ed2e }
            // n = 6, score = 400
            //   72e8                 | mov                 dword ptr [ebp + 0x2f0], 0x3d252280
            //   889dd0030000         | jb                  0xffffffea
            //   baff978142           | mov                 byte ptr [ebp + 0x3d0], bl
            //   c785d403000094f2f32c     | mov    edx, 0x428197ff
            //   c785d80300009afbb270     | mov    dword ptr [ebp + 0x3d4], 0x2cf3f294
            //   c785dc030000d1f3ed2e     | mov    dword ptr [ebp + 0x3d8], 0x70b2fb9a

        $sequence_7 = { c74548ba572c54 8b4540 8a453c 84c0 7518 }
            // n = 5, score = 400
            //   c74548ba572c54       | mov                 dword ptr [ebp + 0x48], 0x542c57ba
            //   8b4540               | mov                 eax, dword ptr [ebp + 0x40]
            //   8a453c               | mov                 al, byte ptr [ebp + 0x3c]
            //   84c0                 | test                al, al
            //   7518                 | jne                 0x1a

        $sequence_8 = { 4885c0 0f8419010000 488b15???????? 4885d2 7517 ba01000000 33c9 }
            // n = 7, score = 100
            //   4885c0               | jne                 0x32
            //   0f8419010000         | dec                 eax
            //   488b15????????       |                     
            //   4885d2               | mov                 ecx, ebx
            //   7517                 | movups              xmmword ptr [eax + 0x20], xmm0
            //   ba01000000           | movups              xmm1, xmmword ptr [edx + 0x30]
            //   33c9                 | movups              xmmword ptr [eax + 0x30], xmm1

        $sequence_9 = { 488bcb 0f1f4000 66660f1f840000000000 8b448c24 35e6845659 }
            // n = 5, score = 100
            //   488bcb               | mov                 dword ptr [ebp + 0x46c], 0x351c4da9
            //   0f1f4000             | mov                 eax, dword ptr [ebp + 0x460]
            //   66660f1f840000000000     | mov    al, byte ptr [ebp + 0x45c]
            //   8b448c24             | push                ebp
            //   35e6845659           | dec                 eax

        $sequence_10 = { 41b8956927f2 e8???????? 488d4dd0 ffd0 b001 }
            // n = 5, score = 100
            //   41b8956927f2         | dec                 eax
            //   e8????????           |                     
            //   488d4dd0             | sub                 ebx, 1
            //   ffd0                 | jne                 0xfffffffd
            //   b001                 | inc                 ecx

        $sequence_11 = { 0f114020 0f104a30 0f114830 488b05???????? }
            // n = 4, score = 100
            //   0f114020             | mov                 byte ptr [ebp + 0x12c], bl
            //   0f104a30             | mov                 dword ptr [ebp + 0x130], 0x49fc57d8
            //   0f114830             | mov                 dword ptr [ebp + 0x468], 0x50544ebb
            //   488b05????????       |                     

        $sequence_12 = { 488d4c2430 41ffd0 85c0 7527 8b442420 2b442428 03442424 }
            // n = 7, score = 100
            //   488d4c2430           | xor                 eax, 0x595684e6
            //   41ffd0               | dec                 eax
            //   85c0                 | lea                 eax, [ebp + 0x1a0]
            //   7527                 | inc                 esp
            //   8b442420             | mov                 byte ptr [eax], bh
            //   2b442428             | dec                 eax
            //   03442424             | lea                 eax, [eax + 1]

        $sequence_13 = { 488d85a0010000 448838 488d4001 4883eb01 75f3 41b001 488d8da0010000 }
            // n = 7, score = 100
            //   488d85a0010000       | lea                 ebp, [eax - 0x6a8]
            //   448838               | dec                 eax
            //   488d4001             | sub                 esp, 0x7a0
            //   4883eb01             | xor                 ebx, ebx
            //   75f3                 | mov                 byte ptr [esp + 0x2c], bl
            //   41b001               | mov                 al, byte ptr [ebp + 0x1c8]
            //   488d8da0010000       | test                al, al

        $sequence_14 = { 4d8d0480 0fb602 83e107 410200 41320429 }
            // n = 5, score = 100
            //   4d8d0480             | dec                 eax
            //   0fb602               | mov                 ecx, ebx
            //   83e107               | nop                 dword ptr [eax]
            //   410200               | nop                 word ptr [eax + eax]
            //   41320429             | mov                 eax, dword ptr [esp + ecx*4 + 0x24]

        $sequence_15 = { e8???????? b9100e0000 ffd0 488d95f0030000 4489bdf0030000 488d0d72aaffff e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   b9100e0000           | mov                 al, 1
            //   ffd0                 | dec                 eax
            //   488d95f0030000       | lea                 ecx, [ebp + 0x1a0]
            //   4489bdf0030000       | dec                 eax
            //   488d0d72aaffff       | test                eax, eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 99328
}