rule win_photoloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.photoloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.photoloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fa2 894704 33c9 b800000040 0fa2 }
            // n = 5, score = 1600
            //   0fa2                 | cpuid               
            //   894704               | mov                 dword ptr [edi + 4], eax
            //   33c9                 | xor                 ecx, ecx
            //   b800000040           | mov                 eax, 0x40000000
            //   0fa2                 | cpuid               

        $sequence_1 = { 8bf7 8d6f10 ff15???????? 0f31 }
            // n = 4, score = 1600
            //   8bf7                 | mov                 esi, edi
            //   8d6f10               | lea                 ebp, [edi + 0x10]
            //   ff15????????         |                     
            //   0f31                 | rdtsc               

        $sequence_2 = { c0c003 0fb6c8 8bc1 83e10f }
            // n = 4, score = 1600
            //   c0c003               | rol                 al, 3
            //   0fb6c8               | movzx               ecx, al
            //   8bc1                 | mov                 eax, ecx
            //   83e10f               | and                 ecx, 0xf

        $sequence_3 = { ff15???????? 25ffffff00 0d00000005 e9???????? 8bd7 }
            // n = 5, score = 1600
            //   ff15????????         |                     
            //   25ffffff00           | and                 eax, 0xffffff
            //   0d00000005           | or                  eax, 0x5000000
            //   e9????????           |                     
            //   8bd7                 | mov                 edx, edi

        $sequence_4 = { b800000040 0fa2 895f0c e8???????? }
            // n = 4, score = 1600
            //   b800000040           | mov                 eax, 0x40000000
            //   0fa2                 | cpuid               
            //   895f0c               | mov                 dword ptr [edi + 0xc], ebx
            //   e8????????           |                     

        $sequence_5 = { f7411400000020 7407 8b41f8 3901 7714 }
            // n = 5, score = 1600
            //   f7411400000020       | test                dword ptr [ecx + 0x14], 0x20000000
            //   7407                 | je                  9
            //   8b41f8               | mov                 eax, dword ptr [ecx - 8]
            //   3901                 | cmp                 dword ptr [ecx], eax
            //   7714                 | ja                  0x16

        $sequence_6 = { 7512 ff15???????? 25ffffff00 0d00000007 eb4a 397b1c 7629 }
            // n = 7, score = 1500
            //   7512                 | and                 eax, 0xffffff
            //   ff15????????         |                     
            //   25ffffff00           | or                  eax, 0x5000000
            //   0d00000007           | mov                 edx, edi
            //   eb4a                 | cmp                 dword ptr [ebx + 0x1c], edi
            //   397b1c               | and                 eax, 0xffffff
            //   7629                 | or                  eax, 0x5000000

        $sequence_7 = { f7f1 438b4cd314 4803cb 4903c9 418d0411 }
            // n = 5, score = 1500
            //   f7f1                 | div                 ecx
            //   438b4cd314           | inc                 ebx
            //   4803cb               | mov                 ecx, dword ptr [ebx + edx*8 + 0x14]
            //   4903c9               | dec                 eax
            //   418d0411             | add                 ecx, ebx

        $sequence_8 = { 33c9 b801000080 0fa2 0fbae216 7307 }
            // n = 5, score = 1500
            //   33c9                 | mov                 edx, edi
            //   b801000080           | cmp                 dword ptr [ebx + 0x1c], edi
            //   0fa2                 | mov                 dword ptr [edi + 4], eax
            //   0fbae216             | xor                 ecx, ecx
            //   7307                 | mov                 eax, 0x40000000

        $sequence_9 = { b90b010000 66394a18 8d41ed 448d59fd 440f44d8 4533c9 4c03da }
            // n = 7, score = 1500
            //   b90b010000           | dec                 ecx
            //   66394a18             | add                 ecx, ecx
            //   8d41ed               | inc                 ecx
            //   448d59fd             | lea                 eax, [ecx + edx]
            //   440f44d8             | mov                 ecx, 0x10b
            //   4533c9               | cmp                 word ptr [edx + 0x18], cx
            //   4c03da               | lea                 eax, [ecx - 0x13]

        $sequence_10 = { 33ff 2175fc 85ff 751d }
            // n = 4, score = 200
            //   33ff                 | cmp                 dword ptr [ecx], eax
            //   2175fc               | ja                  0x1d
            //   85ff                 | or                  eax, 0x5000000
            //   751d                 | mov                 edx, edi

        $sequence_11 = { 89470c e8???????? 894708 5f 5e 5d 5b }
            // n = 7, score = 200
            //   89470c               | and                 ecx, 0xf
            //   e8????????           |                     
            //   894708               | push                0x44
            //   5f                   | pop                 esi
            //   5e                   | push                esi
            //   5d                   | xor                 ebx, ebx
            //   5b                   | lea                 eax, [esp + 0x24]

        $sequence_12 = { 0fb6c3 8d95e8fdffff f7d8 1bc0 f7d0 25???????? }
            // n = 6, score = 200
            //   0fb6c3               | cmp                 dword ptr [ebx + 0x1c], edi
            //   8d95e8fdffff         | mov                 dword ptr [edi + 0xc], ebx
            //   f7d8                 | dec                 eax
            //   1bc0                 | mov                 ebx, dword ptr [esp + 0x40]
            //   f7d0                 | mov                 dword ptr [edi + 8], eax
            //   25????????           |                     

        $sequence_13 = { 57 8bfa ff15???????? 8bac2434010000 25ffffff7f 8b9c2438010000 }
            // n = 6, score = 200
            //   57                   | push                ebx
            //   8bfa                 | xor                 edi, edi
            //   ff15????????         |                     
            //   8bac2434010000       | and                 dword ptr [ebp - 4], esi
            //   25ffffff7f           | test                edi, edi
            //   8b9c2438010000       | jne                 0x21

        $sequence_14 = { 8d461e 50 68???????? 8d1c31 }
            // n = 4, score = 200
            //   8d461e               | rol                 al, 3
            //   50                   | movzx               ecx, al
            //   68????????           |                     
            //   8d1c31               | mov                 eax, ecx

        $sequence_15 = { 8bc8 2bfa 66890c17 46 8d5202 }
            // n = 5, score = 200
            //   8bc8                 | movzx               eax, bl
            //   2bfa                 | lea                 edx, [ebp - 0x218]
            //   66890c17             | neg                 eax
            //   46                   | sbb                 eax, eax
            //   8d5202               | not                 eax

        $sequence_16 = { 6a44 5e 56 33db 8d442424 53 }
            // n = 6, score = 200
            //   6a44                 | mov                 eax, 0x40000000
            //   5e                   | cpuid               
            //   56                   | mov                 dword ptr [edi + 0xc], ebx
            //   33db                 | test                dword ptr [ecx + 0x14], 0x20000000
            //   8d442424             | je                  9
            //   53                   | mov                 eax, dword ptr [ecx - 8]

    condition:
        7 of them and filesize < 107520
}