rule win_pikabot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pikabot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pikabot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ebd3 8b4508 c9 c3 55 8bec }
            // n = 6, score = 1100
            //   ebd3                 | jmp                 0xffffffd5
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_1 = { 83ec0c 8b4508 8945fc 8b450c 8945f8 8b4510 }
            // n = 6, score = 1000
            //   83ec0c               | sub                 esp, 0xc
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_2 = { 837df400 741a 8b45fc 8b4df8 }
            // n = 4, score = 1000
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0
            //   741a                 | je                  0x1c
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

        $sequence_3 = { 40 8945f8 ebd3 8b4508 }
            // n = 4, score = 1000
            //   40                   | inc                 eax
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   ebd3                 | jmp                 0xffffffd5
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_4 = { 8945f8 8b4510 8945f4 8b4510 }
            // n = 4, score = 1000
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_5 = { 8b4510 48 894510 837df400 741a }
            // n = 5, score = 1000
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   48                   | dec                 eax
            //   894510               | mov                 dword ptr [ebp + 0x10], eax
            //   837df400             | cmp                 dword ptr [ebp - 0xc], 0
            //   741a                 | je                  0x1c

        $sequence_6 = { 8b4df8 8a09 8808 8b45fc 40 8945fc 8b45f8 }
            // n = 7, score = 1000
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8a09                 | mov                 cl, byte ptr [ecx]
            //   8808                 | mov                 byte ptr [eax], cl
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   40                   | inc                 eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_7 = { 7ce9 8b4214 2b420c 5f }
            // n = 4, score = 900
            //   7ce9                 | jl                  0xffffffeb
            //   8b4214               | mov                 eax, dword ptr [edx + 0x14]
            //   2b420c               | sub                 eax, dword ptr [edx + 0xc]
            //   5f                   | pop                 edi

        $sequence_8 = { 8a1c08 8d4320 0fb6c8 8d53bf 80fa19 0fb6c3 0f47c8 }
            // n = 7, score = 800
            //   8a1c08               | mov                 bl, byte ptr [eax + ecx]
            //   8d4320               | lea                 eax, [ebx + 0x20]
            //   0fb6c8               | movzx               ecx, al
            //   8d53bf               | lea                 edx, [ebx - 0x41]
            //   80fa19               | cmp                 dl, 0x19
            //   0fb6c3               | movzx               eax, bl
            //   0f47c8               | cmova               ecx, eax

        $sequence_9 = { 56 8bf1 85c9 7419 85d2 7415 }
            // n = 6, score = 700
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   85c9                 | test                ecx, ecx
            //   7419                 | je                  0x1b
            //   85d2                 | test                edx, edx
            //   7415                 | je                  0x17

        $sequence_10 = { 85c9 7436 85ff 7432 }
            // n = 4, score = 700
            //   85c9                 | test                ecx, ecx
            //   7436                 | je                  0x38
            //   85ff                 | test                edi, edi
            //   7432                 | je                  0x34

        $sequence_11 = { 0fabd0 83fa20 6a08 0f43c8 }
            // n = 4, score = 700
            //   0fabd0               | bts                 eax, edx
            //   83fa20               | cmp                 edx, 0x20
            //   6a08                 | push                8
            //   0f43c8               | cmovae              ecx, eax

        $sequence_12 = { e8???????? 8bd0 e8???????? 3b45fc }
            // n = 4, score = 700
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   e8????????           |                     
            //   3b45fc               | cmp                 eax, dword ptr [ebp - 4]

        $sequence_13 = { 41 e8???????? ffd0 c9 c3 }
            // n = 5, score = 700
            //   41                   | inc                 ecx
            //   e8????????           |                     
            //   ffd0                 | call                eax
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_14 = { 6a08 0f43c8 33c1 83fa40 }
            // n = 4, score = 700
            //   6a08                 | push                8
            //   0f43c8               | cmovae              ecx, eax
            //   33c1                 | xor                 eax, ecx
            //   83fa40               | cmp                 edx, 0x40

        $sequence_15 = { 3bc7 72d5 5b 5f 8bc6 }
            // n = 5, score = 700
            //   3bc7                 | cmp                 eax, edi
            //   72d5                 | jb                  0xffffffd7
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi

        $sequence_16 = { 83ec10 53 56 8b35???????? b84d5a0000 57 8955fc }
            // n = 7, score = 700
            //   83ec10               | sub                 esp, 0x10
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b35????????         |                     
            //   b84d5a0000           | mov                 eax, 0x5a4d
            //   57                   | push                edi
            //   8955fc               | mov                 dword ptr [ebp - 4], edx

        $sequence_17 = { 8a040a 84c0 75f6 c60100 8bc6 5e c3 }
            // n = 7, score = 700
            //   8a040a               | mov                 al, byte ptr [edx + ecx]
            //   84c0                 | test                al, al
            //   75f6                 | jne                 0xfffffff8
            //   c60100               | mov                 byte ptr [ecx], 0
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c3                   | ret                 

        $sequence_18 = { 0fb6d1 03c2 0fb6c0 8945f8 }
            // n = 4, score = 600
            //   0fb6d1               | movzx               edx, cl
            //   03c2                 | add                 eax, edx
            //   0fb6c0               | movzx               eax, al
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_19 = { 81f900010000 72f0 8bf0 33d2 }
            // n = 4, score = 600
            //   81f900010000         | cmp                 ecx, 0x100
            //   72f0                 | jb                  0xfffffff2
            //   8bf0                 | mov                 esi, eax
            //   33d2                 | xor                 edx, edx

        $sequence_20 = { 0345f8 03c8 0fb6c9 894df8 }
            // n = 4, score = 600
            //   0345f8               | add                 eax, dword ptr [ebp - 8]
            //   03c8                 | add                 ecx, eax
            //   0fb6c9               | movzx               ecx, cl
            //   894df8               | mov                 dword ptr [ebp - 8], ecx

        $sequence_21 = { 40 3d00010000 72f1 8b35???????? 8bf9 }
            // n = 5, score = 600
            //   40                   | inc                 eax
            //   3d00010000           | cmp                 eax, 0x100
            //   72f1                 | jb                  0xfffffff3
            //   8b35????????         |                     
            //   8bf9                 | mov                 edi, ecx

        $sequence_22 = { 0345f8 03c8 0fb6c1 8945f8 }
            // n = 4, score = 600
            //   0345f8               | add                 eax, dword ptr [ebp - 8]
            //   03c8                 | add                 ecx, eax
            //   0fb6c1               | movzx               eax, cl
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_23 = { 8b01 0d20202020 3d6e74646c 750f }
            // n = 4, score = 400
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   0d20202020           | or                  eax, 0x20202020
            //   3d6e74646c           | cmp                 eax, 0x6c64746e
            //   750f                 | jne                 0x11

        $sequence_24 = { a3???????? 8b45d4 890424 a1???????? ff5058 56 }
            // n = 6, score = 300
            //   a3????????           |                     
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   890424               | mov                 dword ptr [esp], eax
            //   a1????????           |                     
            //   ff5058               | call                dword ptr [eax + 0x58]
            //   56                   | push                esi

        $sequence_25 = { 89442408 31c0 89442404 e8???????? 8b45e4 }
            // n = 5, score = 300
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   31c0                 | xor                 eax, eax
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   e8????????           |                     
            //   8b45e4               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_26 = { 890424 e8???????? 8b8514f9ffff 89442404 a1???????? }
            // n = 5, score = 300
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8b8514f9ffff         | mov                 eax, dword ptr [ebp - 0x6ec]
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   a1????????           |                     

        $sequence_27 = { 890424 e8???????? 8b8560f9ffff 89442404 }
            // n = 4, score = 300
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8b8560f9ffff         | mov                 eax, dword ptr [ebp - 0x6a0]
            //   89442404             | mov                 dword ptr [esp + 4], eax

        $sequence_28 = { 890424 e8???????? 89c2 a1???????? 895048 }
            // n = 5, score = 300
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   89c2                 | mov                 edx, eax
            //   a1????????           |                     
            //   895048               | mov                 dword ptr [eax + 0x48], edx

        $sequence_29 = { a1???????? 8b00 890424 e8???????? a1???????? 8b9060010000 89542404 }
            // n = 7, score = 300
            //   a1????????           |                     
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   a1????????           |                     
            //   8b9060010000         | mov                 edx, dword ptr [eax + 0x160]
            //   89542404             | mov                 dword ptr [esp + 4], edx

        $sequence_30 = { 890424 a1???????? ff9090000000 83ec10 }
            // n = 4, score = 300
            //   890424               | mov                 dword ptr [esp], eax
            //   a1????????           |                     
            //   ff9090000000         | call                dword ptr [eax + 0x90]
            //   83ec10               | sub                 esp, 0x10

    condition:
        7 of them and filesize < 1717248
}