rule win_pinchduke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pinchduke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pinchduke"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c40c 83c610 4f 75c3 e9???????? 8d45f0 50 }
            // n = 7, score = 100
            //   83c40c               | add                 esp, 0xc
            //   83c610               | add                 esi, 0x10
            //   4f                   | dec                 edi
            //   75c3                 | jne                 0xffffffc5
            //   e9????????           |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax

        $sequence_1 = { c6400274 e8???????? 56 e8???????? 59 59 89442414 }
            // n = 7, score = 100
            //   c6400274             | mov                 byte ptr [eax + 2], 0x74
            //   e8????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   89442414             | mov                 dword ptr [esp + 0x14], eax

        $sequence_2 = { e8???????? 59 59 8d8df8fdffff 3bc1 7545 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8d8df8fdffff         | lea                 ecx, [ebp - 0x208]
            //   3bc1                 | cmp                 eax, ecx
            //   7545                 | jne                 0x47

        $sequence_3 = { c685f7fbffff00 e8???????? 8d85f4fbffff 50 e8???????? 83c414 84c0 }
            // n = 7, score = 100
            //   c685f7fbffff00       | mov                 byte ptr [ebp - 0x409], 0
            //   e8????????           |                     
            //   8d85f4fbffff         | lea                 eax, [ebp - 0x40c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   84c0                 | test                al, al

        $sequence_4 = { 68???????? 50 e8???????? 3bc7 59 59 740f }
            // n = 7, score = 100
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   3bc7                 | cmp                 eax, edi
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   740f                 | je                  0x11

        $sequence_5 = { 334dcc 8d943a9979825a 8b7df4 d1c1 8955f0 c1c205 337df8 }
            // n = 7, score = 100
            //   334dcc               | xor                 ecx, dword ptr [ebp - 0x34]
            //   8d943a9979825a       | lea                 edx, [edx + edi + 0x5a827999]
            //   8b7df4               | mov                 edi, dword ptr [ebp - 0xc]
            //   d1c1                 | rol                 ecx, 1
            //   8955f0               | mov                 dword ptr [ebp - 0x10], edx
            //   c1c205               | rol                 edx, 5
            //   337df8               | xor                 edi, dword ptr [ebp - 8]

        $sequence_6 = { c9 c3 833d????????00 752f 833d????????00 }
            // n = 5, score = 100
            //   c9                   | leave               
            //   c3                   | ret                 
            //   833d????????00       |                     
            //   752f                 | jne                 0x31
            //   833d????????00       |                     

        $sequence_7 = { 898618040000 6a08 50 ff15???????? 898608010000 5f 8bc6 }
            // n = 7, score = 100
            //   898618040000         | mov                 dword ptr [esi + 0x418], eax
            //   6a08                 | push                8
            //   50                   | push                eax
            //   ff15????????         |                     
            //   898608010000         | mov                 dword ptr [esi + 0x108], eax
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi

        $sequence_8 = { 03f9 037df0 8908 8b4824 334804 8975fc 334838 }
            // n = 7, score = 100
            //   03f9                 | add                 edi, ecx
            //   037df0               | add                 edi, dword ptr [ebp - 0x10]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8b4824               | mov                 ecx, dword ptr [eax + 0x24]
            //   334804               | xor                 ecx, dword ptr [eax + 4]
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   334838               | xor                 ecx, dword ptr [eax + 0x38]

        $sequence_9 = { 53 e8???????? 59 85ff 7472 c60700 e9???????? }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85ff                 | test                edi, edi
            //   7472                 | je                  0x74
            //   c60700               | mov                 byte ptr [edi], 0
            //   e9????????           |                     

    condition:
        7 of them and filesize < 223680
}