rule win_pipcreat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pipcreat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pipcreat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6800100000 50 ff35???????? e8???????? 83c40c 5f }
            // n = 6, score = 100
            //   6800100000           | push                0x1000
            //   50                   | push                eax
            //   ff35????????         |                     
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   5f                   | pop                 edi

        $sequence_1 = { 6a00 8d442420 6a00 50 6a01 6a02 6a20 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   6a01                 | push                1
            //   6a02                 | push                2
            //   6a20                 | push                0x20

        $sequence_2 = { 83c418 85c0 7436 56 ff35???????? ff15???????? }
            // n = 6, score = 100
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax
            //   7436                 | je                  0x38
            //   56                   | push                esi
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_3 = { 33c0 c3 8b0d???????? 51 ff15???????? }
            // n = 5, score = 100
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_4 = { e8???????? 83c40c ff15???????? 6a3f a3???????? 33db }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   ff15????????         |                     
            //   6a3f                 | push                0x3f
            //   a3????????           |                     
            //   33db                 | xor                 ebx, ebx

        $sequence_5 = { 6a02 6a20 68ff010f00 53 57 52 ffd5 }
            // n = 7, score = 100
            //   6a02                 | push                2
            //   6a20                 | push                0x20
            //   68ff010f00           | push                0xf01ff
            //   53                   | push                ebx
            //   57                   | push                edi
            //   52                   | push                edx
            //   ffd5                 | call                ebp

        $sequence_6 = { 40 3b4510 7cf6 ff35???????? ff15???????? 5f 8bc3 }
            // n = 7, score = 100
            //   40                   | inc                 eax
            //   3b4510               | cmp                 eax, dword ptr [ebp + 0x10]
            //   7cf6                 | jl                  0xfffffff8
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   8bc3                 | mov                 eax, ebx

        $sequence_7 = { 6a00 57 ff15???????? 83c002 83c408 8bf8 66833f00 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   57                   | push                edi
            //   ff15????????         |                     
            //   83c002               | add                 eax, 2
            //   83c408               | add                 esp, 8
            //   8bf8                 | mov                 edi, eax
            //   66833f00             | cmp                 word ptr [edi], 0

        $sequence_8 = { 6a30 6868420010 eb07 6a28 }
            // n = 4, score = 100
            //   6a30                 | push                0x30
            //   6868420010           | push                0x10004268
            //   eb07                 | jmp                 9
            //   6a28                 | push                0x28

        $sequence_9 = { a5 50 33db ff35???????? a4 ff15???????? }
            // n = 6, score = 100
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   50                   | push                eax
            //   33db                 | xor                 ebx, ebx
            //   ff35????????         |                     
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 65536
}