rule win_pipemagic_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pipemagic."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pipemagic"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8bcf e8???????? 8bc8 85c9 7510 53 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   85c9                 | test                ecx, ecx
            //   7510                 | jne                 0x12
            //   53                   | push                ebx

        $sequence_1 = { ff15???????? 59 c7431003000000 5f 5e 5b c9 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   c7431003000000       | mov                 dword ptr [ebx + 0x10], 3
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               

        $sequence_2 = { 0f8722010000 8b513c 03d1 8955f8 8d82f8000000 3bc3 0f870c010000 }
            // n = 7, score = 100
            //   0f8722010000         | ja                  0x128
            //   8b513c               | mov                 edx, dword ptr [ecx + 0x3c]
            //   03d1                 | add                 edx, ecx
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8d82f8000000         | lea                 eax, [edx + 0xf8]
            //   3bc3                 | cmp                 eax, ebx
            //   0f870c010000         | ja                  0x112

        $sequence_3 = { 8945e4 85db 0f8499020000 8b5508 8a01 }
            // n = 5, score = 100
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   85db                 | test                ebx, ebx
            //   0f8499020000         | je                  0x29f
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8a01                 | mov                 al, byte ptr [ecx]

        $sequence_4 = { e8???????? a1???????? 33c9 894dd8 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   a1????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   894dd8               | mov                 dword ptr [ebp - 0x28], ecx

        $sequence_5 = { 8b00 eb03 8b4508 6a04 }
            // n = 4, score = 100
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   eb03                 | jmp                 5
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   6a04                 | push                4

        $sequence_6 = { 59 51 8b4dec 57 e8???????? 57 }
            // n = 6, score = 100
            //   59                   | pop                 ecx
            //   51                   | push                ecx
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   57                   | push                edi
            //   e8????????           |                     
            //   57                   | push                edi

        $sequence_7 = { 83e801 7404 32c0 eb23 e8???????? eb1a e8???????? }
            // n = 7, score = 100
            //   83e801               | sub                 eax, 1
            //   7404                 | je                  6
            //   32c0                 | xor                 al, al
            //   eb23                 | jmp                 0x25
            //   e8????????           |                     
            //   eb1a                 | jmp                 0x1c
            //   e8????????           |                     

        $sequence_8 = { 8d542410 8bce e8???????? e9???????? 83f803 750e }
            // n = 6, score = 100
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   e9????????           |                     
            //   83f803               | cmp                 eax, 3
            //   750e                 | jne                 0x10

        $sequence_9 = { 7404 8b38 eb03 8b7dfc 807e0c00 7530 53 }
            // n = 7, score = 100
            //   7404                 | je                  6
            //   8b38                 | mov                 edi, dword ptr [eax]
            //   eb03                 | jmp                 5
            //   8b7dfc               | mov                 edi, dword ptr [ebp - 4]
            //   807e0c00             | cmp                 byte ptr [esi + 0xc], 0
            //   7530                 | jne                 0x32
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 87040
}