rule win_pirpi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pirpi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pirpi"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8bf8 8d4610 50 8d4c2424 6a0c }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   8d4610               | lea                 eax, [esi + 0x10]
            //   50                   | push                eax
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   6a0c                 | push                0xc

        $sequence_1 = { bf???????? 8bf0 33db c70200000000 f3a7 745c b904000000 }
            // n = 7, score = 200
            //   bf????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   33db                 | xor                 ebx, ebx
            //   c70200000000         | mov                 dword ptr [edx], 0
            //   f3a7                 | repe cmpsd          dword ptr [esi], dword ptr es:[edi]
            //   745c                 | je                  0x5e
            //   b904000000           | mov                 ecx, 4

        $sequence_2 = { 0f849e000000 8d7c2434 83c9ff 33c0 f2ae f7d1 49 }
            // n = 7, score = 200
            //   0f849e000000         | je                  0xa4
            //   8d7c2434             | lea                 edi, [esp + 0x34]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx

        $sequence_3 = { 8bca 8b5510 83e103 52 f3a4 }
            // n = 5, score = 200
            //   8bca                 | mov                 ecx, edx
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   83e103               | and                 ecx, 3
            //   52                   | push                edx
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]

        $sequence_4 = { 8b542404 57 85d2 c705????????00000000 7461 8bfa }
            // n = 6, score = 200
            //   8b542404             | mov                 edx, dword ptr [esp + 4]
            //   57                   | push                edi
            //   85d2                 | test                edx, edx
            //   c705????????00000000     |     
            //   7461                 | je                  0x63
            //   8bfa                 | mov                 edi, edx

        $sequence_5 = { 8bac24f0000000 8d7c241c 2beb 8b07 }
            // n = 4, score = 200
            //   8bac24f0000000       | mov                 ebp, dword ptr [esp + 0xf0]
            //   8d7c241c             | lea                 edi, [esp + 0x1c]
            //   2beb                 | sub                 ebp, ebx
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_6 = { 83fbff 742b b941000000 33c0 8d7c2420 85f6 f3ab }
            // n = 7, score = 200
            //   83fbff               | cmp                 ebx, -1
            //   742b                 | je                  0x2d
            //   b941000000           | mov                 ecx, 0x41
            //   33c0                 | xor                 eax, eax
            //   8d7c2420             | lea                 edi, [esp + 0x20]
            //   85f6                 | test                esi, esi
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_7 = { ff15???????? 8bf0 85f6 897508 7545 8b5d0c }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   897508               | mov                 dword ptr [ebp + 8], esi
            //   7545                 | jne                 0x47
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]

        $sequence_8 = { 81ec10020000 8bd1 b940000000 33c0 57 8dbc2414010000 }
            // n = 6, score = 200
            //   81ec10020000         | sub                 esp, 0x210
            //   8bd1                 | mov                 edx, ecx
            //   b940000000           | mov                 ecx, 0x40
            //   33c0                 | xor                 eax, eax
            //   57                   | push                edi
            //   8dbc2414010000       | lea                 edi, [esp + 0x114]

        $sequence_9 = { 81c41c020000 c3 8bb42430020000 85f6 0f841dffffff b941000000 8d7c2420 }
            // n = 7, score = 200
            //   81c41c020000         | add                 esp, 0x21c
            //   c3                   | ret                 
            //   8bb42430020000       | mov                 esi, dword ptr [esp + 0x230]
            //   85f6                 | test                esi, esi
            //   0f841dffffff         | je                  0xffffff23
            //   b941000000           | mov                 ecx, 0x41
            //   8d7c2420             | lea                 edi, [esp + 0x20]

    condition:
        7 of them and filesize < 327680
}