rule win_pitou_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pitou."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pitou"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bda c1e305 03c3 8bda }
            // n = 4, score = 700
            //   8bda                 | jle                 0x93c0
            //   c1e305               | mov                 edx, eax
            //   03c3                 | sub                 edx, edi
            //   8bda                 | cmp                 edx, 2

        $sequence_1 = { ac 8bda c1e305 03c3 8bda c1eb02 }
            // n = 6, score = 700
            //   ac                   | pop                 es
            //   8bda                 | test                eax, 0x9a13a915
            //   c1e305               | push                edi
            //   03c3                 | test                eax, 0xeb539a12
            //   8bda                 | push                ss
            //   c1eb02               | add                 dword ptr [ecx + 0x15], ebp

        $sequence_2 = { 33c0 ac 8bda c1e305 03c3 }
            // n = 5, score = 700
            //   33c0                 | push                ebx
            //   ac                   | adc                 eax, 0x102a1d36
            //   8bda                 | xor                 ebp, dword ptr [edi + 0x3a364757]
            //   c1e305               | add                 ebx, dword ptr [edx - 0x60ec65ec]
            //   03c3                 | push                edi

        $sequence_3 = { c1e305 03c3 8bda c1eb02 03c3 }
            // n = 5, score = 700
            //   c1e305               | sub                 esi, edi
            //   03c3                 | mov                 edi, dword ptr [esi + 0x250]
            //   8bda                 | sub                 edi, eax
            //   c1eb02               | mov                 esi, 0x800
            //   03c3                 | cmp                 cx, si

        $sequence_4 = { 8a6201 80f457 8acc 80e103 }
            // n = 4, score = 700
            //   8a6201               | jne                 0xffffa7f5
            //   80f457               | mov                 dword ptr [edx + 0x510], eax
            //   8acc                 | cmp                 eax, ebx
            //   80e103               | jne                 0xfffefc3d

        $sequence_5 = { 8bda c1e305 03c3 8bda c1eb02 }
            // n = 5, score = 700
            //   8bda                 | inc                 ecx
            //   c1e305               | setne               al
            //   03c3                 | shr                 eax, 0x10
            //   8bda                 | mov                 eax, ebx
            //   c1eb02               | jne                 0x194f7

        $sequence_6 = { 33c0 ac 8bda c1e305 }
            // n = 4, score = 700
            //   33c0                 | sub                 eax, 0x149a033a
            //   ac                   | ficom               dword ptr [esi]
            //   8bda                 | xor                 esi, dword ptr [ecx]
            //   c1e305               | cmp                 al, byte ptr [ebx]

        $sequence_7 = { 8acc 80e103 8aec c0ed03 }
            // n = 4, score = 700
            //   8acc                 | mov                 dword ptr [ebp - 0x16c], eax
            //   80e103               | mov                 eax, dword ptr [ebp - 0x16c]
            //   8aec                 | mov                 esp, ebp
            //   c0ed03               | mov                 dword ptr [ebp - 0x164], eax

        $sequence_8 = { 8a6201 80f457 8acc 80e103 8aec c0ed03 80e507 }
            // n = 7, score = 700
            //   8a6201               | pop                 edi
            //   80f457               | pop                 esi
            //   8acc                 | mov                 dword ptr [eax + 8], edx
            //   80e103               | mov                 ecx, dword ptr [esi + 4]
            //   8aec                 | mov                 dword ptr [eax + 0xc], ecx
            //   c0ed03               | mov                 edx, dword ptr [esi + 8]
            //   80e507               | mov                 dword ptr [eax + 0x10], edx

        $sequence_9 = { 80e703 c0eb05 80e303 80ff00 }
            // n = 4, score = 700
            //   80e703               | mov                 ax, word ptr [edi + 0x3e]
            //   c0eb05               | cmp                 ax, word ptr [edi + 0x50]
            //   80e303               | jl                  0x13ac2
            //   80ff00               | cmp                 ecx, 2

    condition:
        7 of them and filesize < 1106944
}