rule win_pittytiger_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pittytiger_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pittytiger_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 ffd7 83c410 8d8558f9ffff 50 ff15???????? 50 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   83c410               | add                 esp, 0x10
            //   8d8558f9ffff         | lea                 eax, [ebp - 0x6a8]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_1 = { 33db f3ab ff7508 895dfc 66ab aa }
            // n = 6, score = 100
            //   33db                 | xor                 ebx, ebx
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al

        $sequence_2 = { e8???????? 83c428 8d85e0fdffff 50 8b46f8 ff760c c1e005 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c428               | add                 esp, 0x28
            //   8d85e0fdffff         | lea                 eax, [ebp - 0x220]
            //   50                   | push                eax
            //   8b46f8               | mov                 eax, dword ptr [esi - 8]
            //   ff760c               | push                dword ptr [esi + 0xc]
            //   c1e005               | shl                 eax, 5

        $sequence_3 = { 8d85f8fbffff ffb69c010000 68???????? 50 ffd7 }
            // n = 5, score = 100
            //   8d85f8fbffff         | lea                 eax, [ebp - 0x408]
            //   ffb69c010000         | push                dword ptr [esi + 0x19c]
            //   68????????           |                     
            //   50                   | push                eax
            //   ffd7                 | call                edi

        $sequence_4 = { 8b1d???????? 59 59 56 ffd3 57 }
            // n = 6, score = 100
            //   8b1d????????         |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   56                   | push                esi
            //   ffd3                 | call                ebx
            //   57                   | push                edi

        $sequence_5 = { 3bc3 a3???????? 0f84f2fdffff 8d45b8 c745c441786100 50 57 }
            // n = 7, score = 100
            //   3bc3                 | cmp                 eax, ebx
            //   a3????????           |                     
            //   0f84f2fdffff         | je                  0xfffffdf8
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   c745c441786100       | mov                 dword ptr [ebp - 0x3c], 0x617841
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_6 = { 56 56 ff15???????? 3bc6 8945f4 0f84bc000000 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   56                   | push                esi
            //   ff15????????         |                     
            //   3bc6                 | cmp                 eax, esi
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   0f84bc000000         | je                  0xc2

        $sequence_7 = { 51 53 56 57 33db bf80000000 53 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   33db                 | xor                 ebx, ebx
            //   bf80000000           | mov                 edi, 0x80
            //   53                   | push                ebx

        $sequence_8 = { e8???????? 85c0 0f85e2020000 85f6 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f85e2020000         | jne                 0x2e8
            //   85f6                 | test                esi, esi

        $sequence_9 = { ff750c ff7508 e8???????? 83c420 43 }
            // n = 5, score = 100
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20
            //   43                   | inc                 ebx

    condition:
        7 of them and filesize < 2162688
}