rule win_plaintee_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.plaintee."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.plaintee"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c408 ff15???????? 99 b932000000 8b742410 f7f9 8b4c240c }
            // n = 7, score = 300
            //   83c408               | add                 esp, 8
            //   ff15????????         |                     
            //   99                   | cdq                 
            //   b932000000           | mov                 ecx, 0x32
            //   8b742410             | mov                 esi, dword ptr [esp + 0x10]
            //   f7f9                 | idiv                ecx
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]

        $sequence_1 = { ffd0 8b4c2400 33c0 83f905 0f94c0 }
            // n = 5, score = 300
            //   ffd0                 | call                eax
            //   8b4c2400             | mov                 ecx, dword ptr [esp]
            //   33c0                 | xor                 eax, eax
            //   83f905               | cmp                 ecx, 5
            //   0f94c0               | sete                al

        $sequence_2 = { 7e0f 53 8a1c31 32da }
            // n = 4, score = 300
            //   7e0f                 | jle                 0x11
            //   53                   | push                ebx
            //   8a1c31               | mov                 bl, byte ptr [ecx + esi]
            //   32da                 | xor                 bl, dl

        $sequence_3 = { e8???????? 8bf0 eb02 33f6 8bce e8???????? 8a8669010000 }
            // n = 7, score = 300
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   eb02                 | jmp                 4
            //   33f6                 | xor                 esi, esi
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8a8669010000         | mov                 al, byte ptr [esi + 0x169]

        $sequence_4 = { 51 6a00 52 56 50 ff15???????? 83f85a }
            // n = 7, score = 300
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   52                   | push                edx
            //   56                   | push                esi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83f85a               | cmp                 eax, 0x5a

        $sequence_5 = { 8b8d4c010000 83c25a 51 50 }
            // n = 4, score = 300
            //   8b8d4c010000         | mov                 ecx, dword ptr [ebp + 0x14c]
            //   83c25a               | add                 edx, 0x5a
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_6 = { b932000000 8b742410 f7f9 8b4c240c }
            // n = 4, score = 300
            //   b932000000           | mov                 ecx, 0x32
            //   8b742410             | mov                 esi, dword ptr [esp + 0x10]
            //   f7f9                 | idiv                ecx
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]

        $sequence_7 = { 6802020000 ff15???????? 85c0 740a b001 }
            // n = 5, score = 300
            //   6802020000           | push                0x202
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   b001                 | mov                 al, 1

        $sequence_8 = { 56 8b74240c 50 8b44240c }
            // n = 4, score = 300
            //   56                   | push                esi
            //   8b74240c             | mov                 esi, dword ptr [esp + 0xc]
            //   50                   | push                eax
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]

        $sequence_9 = { 51 8b4c241c 51 ff15???????? }
            // n = 4, score = 300
            //   51                   | push                ecx
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   51                   | push                ecx
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 73728
}