rule win_plead_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.plead."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.plead"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 897d14 e8???????? 83c40c 8d4514 }
            // n = 5, score = 900
            //   56                   | push                esi
            //   897d14               | mov                 dword ptr [ebp + 0x14], edi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d4514               | lea                 eax, [ebp + 0x14]

        $sequence_1 = { 8b4514 56 881c30 ff15???????? }
            // n = 4, score = 900
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   56                   | push                esi
            //   881c30               | mov                 byte ptr [eax + esi], bl
            //   ff15????????         |                     

        $sequence_2 = { 40 50 6a01 ff15???????? 83c40c }
            // n = 5, score = 900
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_3 = { 90 0145fc ff75fc ff15???????? }
            // n = 4, score = 900
            //   90                   | nop                 
            //   0145fc               | add                 dword ptr [ebp - 4], eax
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     

        $sequence_4 = { 53 6a05 ff7508 ff15???????? }
            // n = 4, score = 900
            //   53                   | push                ebx
            //   6a05                 | push                5
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     

        $sequence_5 = { 3bf7 740f ebda 33f6 }
            // n = 4, score = 900
            //   3bf7                 | cmp                 esi, edi
            //   740f                 | je                  0x11
            //   ebda                 | jmp                 0xffffffdc
            //   33f6                 | xor                 esi, esi

        $sequence_6 = { 50 8b4518 03c6 57 }
            // n = 4, score = 900
            //   50                   | push                eax
            //   8b4518               | mov                 eax, dword ptr [ebp + 0x18]
            //   03c6                 | add                 eax, esi
            //   57                   | push                edi

        $sequence_7 = { ebda 33f6 c745fcf8ffffff 3bf7 750c 895dfc }
            // n = 6, score = 900
            //   ebda                 | jmp                 0xffffffdc
            //   33f6                 | xor                 esi, esi
            //   c745fcf8ffffff       | mov                 dword ptr [ebp - 4], 0xfffffff8
            //   3bf7                 | cmp                 esi, edi
            //   750c                 | jne                 0xe
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx

        $sequence_8 = { 40 49 8975fc 75ec 8bc6 5e }
            // n = 6, score = 600
            //   40                   | inc                 eax
            //   49                   | dec                 ecx
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   75ec                 | jne                 0xffffffee
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi

        $sequence_9 = { 81c900ffffff 41 85c9 7e1c 55 }
            // n = 5, score = 600
            //   81c900ffffff         | or                  ecx, 0xffffff00
            //   41                   | inc                 ecx
            //   85c9                 | test                ecx, ecx
            //   7e1c                 | jle                 0x1e
            //   55                   | push                ebp

        $sequence_10 = { 33c0 81c418020000 c21000 8b84241c020000 6a00 6a00 6801020000 }
            // n = 7, score = 600
            //   33c0                 | xor                 eax, eax
            //   81c418020000         | add                 esp, 0x218
            //   c21000               | ret                 0x10
            //   8b84241c020000       | mov                 eax, dword ptr [esp + 0x21c]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6801020000           | push                0x201

        $sequence_11 = { 50 ff15???????? 33c0 81c418020000 }
            // n = 4, score = 600
            //   50                   | push                eax
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   81c418020000         | add                 esp, 0x218

        $sequence_12 = { 7cf1 ffd3 8b35???????? 2bc7 3de8030000 760f }
            // n = 6, score = 600
            //   7cf1                 | jl                  0xfffffff3
            //   ffd3                 | call                ebx
            //   8b35????????         |                     
            //   2bc7                 | sub                 eax, edi
            //   3de8030000           | cmp                 eax, 0x3e8
            //   760f                 | jbe                 0x11

        $sequence_13 = { 8844341c 46 3bf1 7cf1 }
            // n = 4, score = 600
            //   8844341c             | mov                 byte ptr [esp + esi + 0x1c], al
            //   46                   | inc                 esi
            //   3bf1                 | cmp                 esi, ecx
            //   7cf1                 | jl                  0xfffffff3

        $sequence_14 = { c145fc05 8b75fc 33d2 8a10 03f2 40 }
            // n = 6, score = 600
            //   c145fc05             | rol                 dword ptr [ebp - 4], 5
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   33d2                 | xor                 edx, edx
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   03f2                 | add                 esi, edx
            //   40                   | inc                 eax

        $sequence_15 = { 6804010000 ff15???????? 8b4c2412 8b54240e 8b44240c }
            // n = 5, score = 600
            //   6804010000           | push                0x104
            //   ff15????????         |                     
            //   8b4c2412             | mov                 ecx, dword ptr [esp + 0x12]
            //   8b54240e             | mov                 edx, dword ptr [esp + 0xe]
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]

        $sequence_16 = { 648b1530000000 8b520c 8b521c 8b5a08 }
            // n = 4, score = 200
            //   648b1530000000       | mov                 edx, dword ptr fs:[0x30]
            //   8b520c               | mov                 edx, dword ptr [edx + 0xc]
            //   8b521c               | mov                 edx, dword ptr [edx + 0x1c]
            //   8b5a08               | mov                 ebx, dword ptr [edx + 8]

        $sequence_17 = { eb02 8bfa 8955f4 897df0 }
            // n = 4, score = 100
            //   eb02                 | jmp                 4
            //   8bfa                 | mov                 edi, edx
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi

        $sequence_18 = { 8dbd00ffffff 33db 891f 0fb602 42 }
            // n = 5, score = 100
            //   8dbd00ffffff         | lea                 edi, [ebp - 0x100]
            //   33db                 | xor                 ebx, ebx
            //   891f                 | mov                 dword ptr [edi], ebx
            //   0fb602               | movzx               eax, byte ptr [edx]
            //   42                   | inc                 edx

        $sequence_19 = { 85c0 750f 6800800000 6a00 ff75f8 ff5648 eb0d }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   750f                 | jne                 0x11
            //   6800800000           | push                0x8000
            //   6a00                 | push                0
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff5648               | call                dword ptr [esi + 0x48]
            //   eb0d                 | jmp                 0xf

        $sequence_20 = { d3e0 f7c200000004 7403 80cc02 }
            // n = 4, score = 100
            //   d3e0                 | shl                 eax, cl
            //   f7c200000004         | test                edx, 0x4000000
            //   7403                 | je                  5
            //   80cc02               | or                  ah, 2

        $sequence_21 = { 75f1 5e 8b4624 03c3 668b1450 }
            // n = 5, score = 100
            //   75f1                 | jne                 0xfffffff3
            //   5e                   | pop                 esi
            //   8b4624               | mov                 eax, dword ptr [esi + 0x24]
            //   03c3                 | add                 eax, ebx
            //   668b1450             | mov                 dx, word ptr [eax + edx*2]

        $sequence_22 = { 8b562c c7048a00000000 8b7df0 8b07 }
            // n = 4, score = 100
            //   8b562c               | mov                 edx, dword ptr [esi + 0x2c]
            //   c7048a00000000       | mov                 dword ptr [edx + ecx*4], 0
            //   8b7df0               | mov                 edi, dword ptr [ebp - 0x10]
            //   8b07                 | mov                 eax, dword ptr [edi]

        $sequence_23 = { 8b4510 40 c1c803 ab 3bef }
            // n = 5, score = 100
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   40                   | inc                 eax
            //   c1c803               | ror                 eax, 3
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   3bef                 | cmp                 ebp, edi

    condition:
        7 of them and filesize < 8224768
}