rule win_ployx_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ployx."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ployx"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d85a4feffff 68???????? 50 e8???????? 8d85a4feffff 68???????? 50 }
            // n = 7, score = 100
            //   8d85a4feffff         | lea                 eax, [ebp - 0x15c]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85a4feffff         | lea                 eax, [ebp - 0x15c]
            //   68????????           |                     
            //   50                   | push                eax

        $sequence_1 = { 81f9???????? 7ce7 5b 8bc6 5f 5e c20400 }
            // n = 7, score = 100
            //   81f9????????         |                     
            //   7ce7                 | jl                  0xffffffe9
            //   5b                   | pop                 ebx
            //   8bc6                 | mov                 eax, esi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c20400               | ret                 4

        $sequence_2 = { 83c418 8945f4 85c0 746f 50 e8???????? 50 }
            // n = 7, score = 100
            //   83c418               | add                 esp, 0x18
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   85c0                 | test                eax, eax
            //   746f                 | je                  0x71
            //   50                   | push                eax
            //   e8????????           |                     
            //   50                   | push                eax

        $sequence_3 = { e8???????? 8bf8 8b4d08 47 47 8d0437 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   47                   | inc                 edi
            //   47                   | inc                 edi
            //   8d0437               | lea                 eax, [edi + esi]
            //   50                   | push                eax

        $sequence_4 = { 0f8584000000 8d45d4 50 e8???????? }
            // n = 4, score = 100
            //   0f8584000000         | jne                 0x8a
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 03c1 99 f7f9 8bf2 83c608 85f6 7e42 }
            // n = 7, score = 100
            //   03c1                 | add                 eax, ecx
            //   99                   | cdq                 
            //   f7f9                 | idiv                ecx
            //   8bf2                 | mov                 esi, edx
            //   83c608               | add                 esi, 8
            //   85f6                 | test                esi, esi
            //   7e42                 | jle                 0x44

        $sequence_6 = { 33ff 99 59 f7f9 8bc2 03c1 99 }
            // n = 7, score = 100
            //   33ff                 | xor                 edi, edi
            //   99                   | cdq                 
            //   59                   | pop                 ecx
            //   f7f9                 | idiv                ecx
            //   8bc2                 | mov                 eax, edx
            //   03c1                 | add                 eax, ecx
            //   99                   | cdq                 

        $sequence_7 = { aa 53 8d442414 50 ff15???????? 8d442410 68???????? }
            // n = 7, score = 100
            //   aa                   | stosb               byte ptr es:[edi], al
            //   53                   | push                ebx
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   68????????           |                     

        $sequence_8 = { 880c30 40 0fb64dfc 8a89d8302700 880c30 40 0fb6ca }
            // n = 7, score = 100
            //   880c30               | mov                 byte ptr [eax + esi], cl
            //   40                   | inc                 eax
            //   0fb64dfc             | movzx               ecx, byte ptr [ebp - 4]
            //   8a89d8302700         | mov                 cl, byte ptr [ecx + 0x2730d8]
            //   880c30               | mov                 byte ptr [eax + esi], cl
            //   40                   | inc                 eax
            //   0fb6ca               | movzx               ecx, dl

        $sequence_9 = { 83c42c 0005???????? bd???????? bb04010000 55 53 }
            // n = 6, score = 100
            //   83c42c               | add                 esp, 0x2c
            //   0005????????         |                     
            //   bd????????           |                     
            //   bb04010000           | mov                 ebx, 0x104
            //   55                   | push                ebp
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 229376
}