rule win_plugx_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.plugx."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.plugx"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 55 8bec 51 0fb74612 }
            // n = 4, score = 1400
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   0fb74612             | movzx               eax, word ptr [esi + 0x12]

        $sequence_1 = { 55 8bec 8b450c 81780402700000 }
            // n = 4, score = 1400
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   81780402700000       | cmp                 dword ptr [eax + 4], 0x7002

        $sequence_2 = { 53 6a00 6a00 6a02 ffd0 85c0 }
            // n = 6, score = 1400
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   ffd0                 | call                eax
            //   85c0                 | test                eax, eax

        $sequence_3 = { 51 56 57 6a1c 8bf8 e8???????? 8bf0 }
            // n = 7, score = 1400
            //   51                   | push                ecx
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a1c                 | push                0x1c
            //   8bf8                 | mov                 edi, eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_4 = { 56 8b750c 8b4604 050070ffff }
            // n = 4, score = 1400
            //   56                   | push                esi
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   050070ffff           | add                 eax, 0xffff7000

        $sequence_5 = { 41 3bca 7ce0 3bca }
            // n = 4, score = 1400
            //   41                   | inc                 ecx
            //   3bca                 | cmp                 ecx, edx
            //   7ce0                 | jl                  0xffffffe2
            //   3bca                 | cmp                 ecx, edx

        $sequence_6 = { 0145f4 8b45fc 0fafc3 33d2 }
            // n = 4, score = 1400
            //   0145f4               | add                 dword ptr [ebp - 0xc], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   0fafc3               | imul                eax, ebx
            //   33d2                 | xor                 edx, edx

        $sequence_7 = { e8???????? 85c0 7508 e8???????? 8945fc }
            // n = 5, score = 1000
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7508                 | jne                 0xa
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_8 = { e8???????? 3de5030000 7407 e8???????? }
            // n = 4, score = 1000
            //   e8????????           |                     
            //   3de5030000           | cmp                 eax, 0x3e5
            //   7407                 | je                  9
            //   e8????????           |                     

        $sequence_9 = { 85c0 7413 e8???????? 3de5030000 }
            // n = 4, score = 1000
            //   85c0                 | test                eax, eax
            //   7413                 | je                  0x15
            //   e8????????           |                     
            //   3de5030000           | cmp                 eax, 0x3e5

        $sequence_10 = { e8???????? 85c0 7407 b84f050000 }
            // n = 4, score = 900
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   b84f050000           | mov                 eax, 0x54f

        $sequence_11 = { 50 ff15???????? a3???????? 8b4d18 }
            // n = 4, score = 900
            //   50                   | push                eax
            //   ff15????????         |                     
            //   a3????????           |                     
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]

        $sequence_12 = { e8???????? 85c0 750a e8???????? 8945fc }
            // n = 5, score = 800
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_13 = { 85c0 750d e8???????? 8945f4 }
            // n = 4, score = 700
            //   85c0                 | test                eax, eax
            //   750d                 | jne                 0xf
            //   e8????????           |                     
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax

        $sequence_14 = { 6a00 6a00 6a04 6a00 6a01 6800000040 57 }
            // n = 7, score = 700
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6800000040           | push                0x40000000
            //   57                   | push                edi

        $sequence_15 = { 57 e8???????? eb0c e8???????? }
            // n = 4, score = 600
            //   57                   | push                edi
            //   e8????????           |                     
            //   eb0c                 | jmp                 0xe
            //   e8????????           |                     

        $sequence_16 = { 51 6a00 6800100000 6800100000 68ff000000 6a00 6803000040 }
            // n = 7, score = 600
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   6800100000           | push                0x1000
            //   6800100000           | push                0x1000
            //   68ff000000           | push                0xff
            //   6a00                 | push                0
            //   6803000040           | push                0x40000003

        $sequence_17 = { 6819000200 6a00 6a00 6a00 51 }
            // n = 5, score = 600
            //   6819000200           | push                0x20019
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   51                   | push                ecx

        $sequence_18 = { 50 ff75e8 6802000080 e8???????? }
            // n = 4, score = 500
            //   50                   | push                eax
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   6802000080           | push                0x80000002
            //   e8????????           |                     

        $sequence_19 = { ffd7 a3???????? 56 ffd0 }
            // n = 4, score = 500
            //   ffd7                 | call                edi
            //   a3????????           |                     
            //   56                   | push                esi
            //   ffd0                 | call                eax

        $sequence_20 = { 6a01 6a00 e8???????? a3???????? 6800080000 68???????? }
            // n = 6, score = 400
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   e8????????           |                     
            //   a3????????           |                     
            //   6800080000           | push                0x800
            //   68????????           |                     

        $sequence_21 = { 51 6a02 e8???????? 6800f00000 }
            // n = 4, score = 400
            //   51                   | push                ecx
            //   6a02                 | push                2
            //   e8????????           |                     
            //   6800f00000           | push                0xf000

        $sequence_22 = { 89442424 8b442424 6808020000 6a00 }
            // n = 4, score = 400
            //   89442424             | mov                 dword ptr [esp + 0x24], eax
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   6808020000           | push                0x208
            //   6a00                 | push                0

        $sequence_23 = { 6800080000 68???????? e8???????? 6800080000 68???????? e8???????? }
            // n = 6, score = 400
            //   6800080000           | push                0x800
            //   68????????           |                     
            //   e8????????           |                     
            //   6800080000           | push                0x800
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_24 = { 6808020000 6a00 ff74242c e8???????? }
            // n = 4, score = 400
            //   6808020000           | push                0x208
            //   6a00                 | push                0
            //   ff74242c             | push                dword ptr [esp + 0x2c]
            //   e8????????           |                     

        $sequence_25 = { 5d c21000 55 53 57 56 83ec18 }
            // n = 7, score = 400
            //   5d                   | pop                 ebp
            //   c21000               | ret                 0x10
            //   55                   | push                ebp
            //   53                   | push                ebx
            //   57                   | push                edi
            //   56                   | push                esi
            //   83ec18               | sub                 esp, 0x18

        $sequence_26 = { 89742434 89f1 8b442434 e8???????? }
            // n = 4, score = 400
            //   89742434             | mov                 dword ptr [esp + 0x34], esi
            //   89f1                 | mov                 ecx, esi
            //   8b442434             | mov                 eax, dword ptr [esp + 0x34]
            //   e8????????           |                     

        $sequence_27 = { 50 56 ffb42480000000 ff15???????? }
            // n = 4, score = 400
            //   50                   | push                eax
            //   56                   | push                esi
            //   ffb42480000000       | push                dword ptr [esp + 0x80]
            //   ff15????????         |                     

        $sequence_28 = { 50 6802000080 53 e8???????? }
            // n = 4, score = 300
            //   50                   | push                eax
            //   6802000080           | push                0x80000002
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_29 = { 6a5c ff74241c e8???????? 83c408 }
            // n = 4, score = 300
            //   6a5c                 | push                0x5c
            //   ff74241c             | push                dword ptr [esp + 0x1c]
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_30 = { 56 ff742478 ffd0 89442420 }
            // n = 4, score = 300
            //   56                   | push                esi
            //   ff742478             | push                dword ptr [esp + 0x78]
            //   ffd0                 | call                eax
            //   89442420             | mov                 dword ptr [esp + 0x20], eax

        $sequence_31 = { 6a00 ff74245c e8???????? 83c40c }
            // n = 4, score = 300
            //   6a00                 | push                0
            //   ff74245c             | push                dword ptr [esp + 0x5c]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_32 = { 40 eb95 89f1 c644242a00 }
            // n = 4, score = 300
            //   40                   | inc                 eax
            //   eb95                 | jmp                 0xffffff97
            //   89f1                 | mov                 ecx, esi
            //   c644242a00           | mov                 byte ptr [esp + 0x2a], 0

    condition:
        7 of them and filesize < 1284096
}