rule win_pngdowner_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pngdowner."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pngdowner"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c410 85c0 0f856d010000 8d842418020000 8d8c2498010000 50 }
            // n = 6, score = 200
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax
            //   0f856d010000         | jne                 0x173
            //   8d842418020000       | lea                 eax, [esp + 0x218]
            //   8d8c2498010000       | lea                 ecx, [esp + 0x198]
            //   50                   | push                eax

        $sequence_1 = { b910270000 f7f9 52 68???????? 8d942424010000 }
            // n = 5, score = 200
            //   b910270000           | mov                 ecx, 0x2710
            //   f7f9                 | idiv                ecx
            //   52                   | push                edx
            //   68????????           |                     
            //   8d942424010000       | lea                 edx, [esp + 0x124]

        $sequence_2 = { 83f85a 7714 8088????????10 8ac8 80c120 888800e44000 }
            // n = 6, score = 200
            //   83f85a               | cmp                 eax, 0x5a
            //   7714                 | ja                  0x16
            //   8088????????10       |                     
            //   8ac8                 | mov                 cl, al
            //   80c120               | add                 cl, 0x20
            //   888800e44000         | mov                 byte ptr [eax + 0x40e400], cl

        $sequence_3 = { b910270000 f7f9 52 68???????? }
            // n = 4, score = 200
            //   b910270000           | mov                 ecx, 0x2710
            //   f7f9                 | idiv                ecx
            //   52                   | push                edx
            //   68????????           |                     

        $sequence_4 = { 83c8ff eb1f 8bce 83e61f c1f905 8bc6 8b0c8d40e64000 }
            // n = 7, score = 200
            //   83c8ff               | or                  eax, 0xffffffff
            //   eb1f                 | jmp                 0x21
            //   8bce                 | mov                 ecx, esi
            //   83e61f               | and                 esi, 0x1f
            //   c1f905               | sar                 ecx, 5
            //   8bc6                 | mov                 eax, esi
            //   8b0c8d40e64000       | mov                 ecx, dword ptr [ecx*4 + 0x40e640]

        $sequence_5 = { 99 b910270000 f7f9 8d84241c010000 }
            // n = 4, score = 200
            //   99                   | cdq                 
            //   b910270000           | mov                 ecx, 0x2710
            //   f7f9                 | idiv                ecx
            //   8d84241c010000       | lea                 eax, [esp + 0x11c]

        $sequence_6 = { e8???????? 85ff 0f85cf000000 53 8b5c2428 55 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   85ff                 | test                edi, edi
            //   0f85cf000000         | jne                 0xd5
            //   53                   | push                ebx
            //   8b5c2428             | mov                 ebx, dword ptr [esp + 0x28]
            //   55                   | push                ebp

        $sequence_7 = { 8d7c2420 8d542420 f3ab 8d4c2414 51 6800000100 }
            // n = 6, score = 200
            //   8d7c2420             | lea                 edi, [esp + 0x20]
            //   8d542420             | lea                 edx, [esp + 0x20]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   51                   | push                ecx
            //   6800000100           | push                0x10000

        $sequence_8 = { 50 89542414 c644240d73 ff15???????? 85c0 7430 68???????? }
            // n = 7, score = 200
            //   50                   | push                eax
            //   89542414             | mov                 dword ptr [esp + 0x14], edx
            //   c644240d73           | mov                 byte ptr [esp + 0xd], 0x73
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7430                 | je                  0x32
            //   68????????           |                     

        $sequence_9 = { 0f84e9000000 8b7508 8b7d0c 8d0520e34000 }
            // n = 4, score = 200
            //   0f84e9000000         | je                  0xef
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   8d0520e34000         | lea                 eax, [0x40e320]

    condition:
        7 of them and filesize < 131072
}