rule win_pocodown_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pocodown."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pocodown"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b8c2488000000 e8???????? 85c0 0f849d010000 }
            // n = 4, score = 200
            //   8b8c2488000000       | dec                 eax
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f849d010000         | jne                 0x2e

        $sequence_1 = { 8b8c2488000000 e8???????? 03442460 89842488000000 }
            // n = 4, score = 200
            //   8b8c2488000000       | mov                 ecx, dword ptr [esp + 0x88]
            //   e8????????           |                     
            //   03442460             | add                 eax, dword ptr [esp + 0x60]
            //   89842488000000       | mov                 dword ptr [esp + 0x88], eax

        $sequence_2 = { 8b8c2488000000 8d840801fcffff 8944244c 837c244c00 }
            // n = 4, score = 200
            //   8b8c2488000000       | mov                 ecx, dword ptr [esp + 0x88]
            //   8d840801fcffff       | lea                 eax, [eax + ecx - 0x3ff]
            //   8944244c             | mov                 dword ptr [esp + 0x4c], eax
            //   837c244c00           | cmp                 dword ptr [esp + 0x4c], 0

        $sequence_3 = { 8b8c2488000000 e8???????? 89842488000000 488b442478 }
            // n = 4, score = 200
            //   8b8c2488000000       | mov                 ecx, dword ptr [esp + 0x88]
            //   e8????????           |                     
            //   89842488000000       | test                eax, eax
            //   488b442478           | je                  0x2b

        $sequence_4 = { 8b8c2488000000 8d8401f33e706d 89842488000000 ba05000000 }
            // n = 4, score = 200
            //   8b8c2488000000       | mov                 ecx, dword ptr [esp + 0x88]
            //   8d8401f33e706d       | lea                 eax, [ecx + eax + 0x6d703ef3]
            //   89842488000000       | mov                 dword ptr [esp + 0x88], eax
            //   ba05000000           | mov                 edx, 5

        $sequence_5 = { 8b8c2488000000 e8???????? 4885c0 7529 }
            // n = 4, score = 200
            //   8b8c2488000000       | mov                 ecx, dword ptr [esp + 0x88]
            //   e8????????           |                     
            //   4885c0               | dec                 eax
            //   7529                 | cmp                 dword ptr [esp + 0x90], 0

        $sequence_6 = { 8b8c2488000000 e8???????? 4883bc249000000000 741a }
            // n = 4, score = 200
            //   8b8c2488000000       | mov                 ecx, dword ptr [esp + 0x88]
            //   e8????????           |                     
            //   4883bc249000000000     | dec    eax
            //   741a                 | cmp                 dword ptr [esp + 0x90], 0

        $sequence_7 = { 8b8c2488000000 ff15???????? 85c0 7519 }
            // n = 4, score = 200
            //   8b8c2488000000       | mov                 eax, dword ptr [esp + 0x88]
            //   ff15????????         |                     
            //   85c0                 | mov                 ecx, dword ptr [esp + 0x60]
            //   7519                 | xor                 ecx, eax

    condition:
        7 of them and filesize < 6703104
}