rule win_poison_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.poison_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.poison_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f3ab 6810270000 8d8dc4d5ffff 6a01 }
            // n = 4, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   6810270000           | push                0x2710
            //   8d8dc4d5ffff         | lea                 ecx, [ebp - 0x2a3c]
            //   6a01                 | push                1

        $sequence_1 = { 83e61f 8b048580c54000 8b04f0 83f8ff }
            // n = 4, score = 100
            //   83e61f               | and                 esi, 0x1f
            //   8b048580c54000       | mov                 eax, dword ptr [eax*4 + 0x40c580]
            //   8b04f0               | mov                 eax, dword ptr [eax + esi*8]
            //   83f8ff               | cmp                 eax, -1

        $sequence_2 = { 33f3 8bf9 8930 8bf1 c1ef10 c1e908 }
            // n = 6, score = 100
            //   33f3                 | xor                 esi, ebx
            //   8bf9                 | mov                 edi, ecx
            //   8930                 | mov                 dword ptr [eax], esi
            //   8bf1                 | mov                 esi, ecx
            //   c1ef10               | shr                 edi, 0x10
            //   c1e908               | shr                 ecx, 8

        $sequence_3 = { 33d7 8b7c2414 c1ef18 8b3cbd30984000 }
            // n = 4, score = 100
            //   33d7                 | xor                 edx, edi
            //   8b7c2414             | mov                 edi, dword ptr [esp + 0x14]
            //   c1ef18               | shr                 edi, 0x18
            //   8b3cbd30984000       | mov                 edi, dword ptr [edi*4 + 0x409830]

        $sequence_4 = { 8ac8 80c120 888840b34000 eb1f 83f861 }
            // n = 5, score = 100
            //   8ac8                 | mov                 cl, al
            //   80c120               | add                 cl, 0x20
            //   888840b34000         | mov                 byte ptr [eax + 0x40b340], cl
            //   eb1f                 | jmp                 0x21
            //   83f861               | cmp                 eax, 0x61

        $sequence_5 = { 8bd3 c1ea18 c1ed10 8b149530984000 }
            // n = 4, score = 100
            //   8bd3                 | mov                 edx, ebx
            //   c1ea18               | shr                 edx, 0x18
            //   c1ed10               | shr                 ebp, 0x10
            //   8b149530984000       | mov                 edx, dword ptr [edx*4 + 0x409830]

        $sequence_6 = { 331c9530984000 8bd7 81e2ff000000 331c9530a44000 8b10 }
            // n = 5, score = 100
            //   331c9530984000       | xor                 ebx, dword ptr [edx*4 + 0x409830]
            //   8bd7                 | mov                 edx, edi
            //   81e2ff000000         | and                 edx, 0xff
            //   331c9530a44000       | xor                 ebx, dword ptr [edx*4 + 0x40a430]
            //   8b10                 | mov                 edx, dword ptr [eax]

        $sequence_7 = { 8bd9 c1eb18 895c2420 8bdf 8b7c2420 c1eb10 }
            // n = 6, score = 100
            //   8bd9                 | mov                 ebx, ecx
            //   c1eb18               | shr                 ebx, 0x18
            //   895c2420             | mov                 dword ptr [esp + 0x20], ebx
            //   8bdf                 | mov                 ebx, edi
            //   8b7c2420             | mov                 edi, dword ptr [esp + 0x20]
            //   c1eb10               | shr                 ebx, 0x10

        $sequence_8 = { 8a6e08 8a4e09 c1e108 0bca 33d2 8a560b }
            // n = 6, score = 100
            //   8a6e08               | mov                 ch, byte ptr [esi + 8]
            //   8a4e09               | mov                 cl, byte ptr [esi + 9]
            //   c1e108               | shl                 ecx, 8
            //   0bca                 | or                  ecx, edx
            //   33d2                 | xor                 edx, edx
            //   8a560b               | mov                 dl, byte ptr [esi + 0xb]

        $sequence_9 = { 330c9530a04000 8bd5 81e2ff000000 81e3ff000000 c1ed18 }
            // n = 5, score = 100
            //   330c9530a04000       | xor                 ecx, dword ptr [edx*4 + 0x40a030]
            //   8bd5                 | mov                 edx, ebp
            //   81e2ff000000         | and                 edx, 0xff
            //   81e3ff000000         | and                 ebx, 0xff
            //   c1ed18               | shr                 ebp, 0x18

    condition:
        7 of them and filesize < 101688
}