rule win_poldat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.poldat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.poldat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8b4514 83c410 8906 8b4510 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   83c410               | add                 esp, 0x10
            //   8906                 | mov                 dword ptr [esi], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_1 = { c74724c0324000 8b4c2418 83f9ff 750c c744241806000000 8b4c2418 }
            // n = 6, score = 100
            //   c74724c0324000       | mov                 dword ptr [edi + 0x24], 0x4032c0
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]
            //   83f9ff               | cmp                 ecx, -1
            //   750c                 | jne                 0xe
            //   c744241806000000     | mov                 dword ptr [esp + 0x18], 6
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]

        $sequence_2 = { 89be4c0c0000 89be500c0000 89be540c0000 8bc6 5f }
            // n = 5, score = 100
            //   89be4c0c0000         | mov                 dword ptr [esi + 0xc4c], edi
            //   89be500c0000         | mov                 dword ptr [esi + 0xc50], edi
            //   89be540c0000         | mov                 dword ptr [esi + 0xc54], edi
            //   8bc6                 | mov                 eax, esi
            //   5f                   | pop                 edi

        $sequence_3 = { 8b4720 895718 3bc2 750a c74720a0324000 }
            // n = 5, score = 100
            //   8b4720               | mov                 eax, dword ptr [edi + 0x20]
            //   895718               | mov                 dword ptr [edi + 0x18], edx
            //   3bc2                 | cmp                 eax, edx
            //   750a                 | jne                 0xc
            //   c74720a0324000       | mov                 dword ptr [edi + 0x20], 0x4032a0

        $sequence_4 = { 8d888c000000 8d9080090000 8988100b0000 8d88740a0000 8988280b0000 33c9 c780180b000018b24100 }
            // n = 7, score = 100
            //   8d888c000000         | lea                 ecx, [eax + 0x8c]
            //   8d9080090000         | lea                 edx, [eax + 0x980]
            //   8988100b0000         | mov                 dword ptr [eax + 0xb10], ecx
            //   8d88740a0000         | lea                 ecx, [eax + 0xa74]
            //   8988280b0000         | mov                 dword ptr [eax + 0xb28], ecx
            //   33c9                 | xor                 ecx, ecx
            //   c780180b000018b24100     | mov    dword ptr [eax + 0xb18], 0x41b218

        $sequence_5 = { 50 e8???????? 55 8d86bc0a0000 57 50 c786b80a0000901f0000 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   55                   | push                ebp
            //   8d86bc0a0000         | lea                 eax, [esi + 0xabc]
            //   57                   | push                edi
            //   50                   | push                eax
            //   c786b80a0000901f0000     | mov    dword ptr [esi + 0xab8], 0x1f90

        $sequence_6 = { 8bc7 83e007 83ed03 8b148dbc9c4100 }
            // n = 4, score = 100
            //   8bc7                 | mov                 eax, edi
            //   83e007               | and                 eax, 7
            //   83ed03               | sub                 ebp, 3
            //   8b148dbc9c4100       | mov                 edx, dword ptr [ecx*4 + 0x419cbc]

        $sequence_7 = { c3 55 8bec 81ec68040000 8065fc00 53 56 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ec68040000         | sub                 esp, 0x468
            //   8065fc00             | and                 byte ptr [ebp - 4], 0
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_8 = { 2bc8 03c7 51 6a00 8d441804 50 }
            // n = 6, score = 100
            //   2bc8                 | sub                 ecx, eax
            //   03c7                 | add                 eax, edi
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   8d441804             | lea                 eax, [eax + ebx + 4]
            //   50                   | push                eax

        $sequence_9 = { 50 e8???????? 59 e8???????? 6a04 99 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   6a04                 | push                4
            //   99                   | cdq                 

    condition:
        7 of them and filesize < 247808
}