rule win_polpo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.polpo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.polpo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 66895004 8a0d???????? 884806 8b45b4 8bf0 8da42400000000 8a08 }
            // n = 7, score = 100
            //   66895004             | mov                 word ptr [eax + 4], dx
            //   8a0d????????         |                     
            //   884806               | mov                 byte ptr [eax + 6], cl
            //   8b45b4               | mov                 eax, dword ptr [ebp - 0x4c]
            //   8bf0                 | mov                 esi, eax
            //   8da42400000000       | lea                 esp, [esp]
            //   8a08                 | mov                 cl, byte ptr [eax]

        $sequence_1 = { f3a5 8bc8 83e103 f3a4 8d45dc }
            // n = 5, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8d45dc               | lea                 eax, [ebp - 0x24]

        $sequence_2 = { 3acb 75f9 2bc6 8dbd4cf7ffff 4f 8a4f01 47 }
            // n = 7, score = 100
            //   3acb                 | cmp                 cl, bl
            //   75f9                 | jne                 0xfffffffb
            //   2bc6                 | sub                 eax, esi
            //   8dbd4cf7ffff         | lea                 edi, [ebp - 0x8b4]
            //   4f                   | dec                 edi
            //   8a4f01               | mov                 cl, byte ptr [edi + 1]
            //   47                   | inc                 edi

        $sequence_3 = { 8bc8 c1e902 f3a5 8bc8 83e103 837d0c00 }
            // n = 6, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   83e103               | and                 ecx, 3
            //   837d0c00             | cmp                 dword ptr [ebp + 0xc], 0

        $sequence_4 = { 6a00 52 898df4faffff e8???????? b908000000 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   52                   | push                edx
            //   898df4faffff         | mov                 dword ptr [ebp - 0x50c], ecx
            //   e8????????           |                     
            //   b908000000           | mov                 ecx, 8

        $sequence_5 = { 2bfe 8d9b00000000 8b1437 8b4c3708 }
            // n = 4, score = 100
            //   2bfe                 | sub                 edi, esi
            //   8d9b00000000         | lea                 ebx, [ebx]
            //   8b1437               | mov                 edx, dword ptr [edi + esi]
            //   8b4c3708             | mov                 ecx, dword ptr [edi + esi + 8]

        $sequence_6 = { 33cd e8???????? 8be5 5d c20800 81ff00001000 0f8387000000 }
            // n = 7, score = 100
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   81ff00001000         | cmp                 edi, 0x100000
            //   0f8387000000         | jae                 0x8d

        $sequence_7 = { 85c0 753e 6a02 56 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   753e                 | jne                 0x40
            //   6a02                 | push                2
            //   56                   | push                esi

        $sequence_8 = { 83e03f 0fb680c0940120 83e23f 41 884602 8a92c0940120 885603 }
            // n = 7, score = 100
            //   83e03f               | and                 eax, 0x3f
            //   0fb680c0940120       | movzx               eax, byte ptr [eax + 0x200194c0]
            //   83e23f               | and                 edx, 0x3f
            //   41                   | inc                 ecx
            //   884602               | mov                 byte ptr [esi + 2], al
            //   8a92c0940120         | mov                 dl, byte ptr [edx + 0x200194c0]
            //   885603               | mov                 byte ptr [esi + 3], dl

        $sequence_9 = { 8985edfeffff 668985f1feffff 8885f3feffff 8845ec 8945ed 8945f1 }
            // n = 6, score = 100
            //   8985edfeffff         | mov                 dword ptr [ebp - 0x113], eax
            //   668985f1feffff       | mov                 word ptr [ebp - 0x10f], ax
            //   8885f3feffff         | mov                 byte ptr [ebp - 0x10d], al
            //   8845ec               | mov                 byte ptr [ebp - 0x14], al
            //   8945ed               | mov                 dword ptr [ebp - 0x13], eax
            //   8945f1               | mov                 dword ptr [ebp - 0xf], eax

    condition:
        7 of them and filesize < 250880
}