rule win_polyglot_ransom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.polyglot_ransom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.polyglot_ransom"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 207370 65676e 657265 2064656c 20636f 6d 7075 }
            // n = 7, score = 100
            //   207370               | and                 byte ptr [ebx + 0x70], dh
            //   65676e               | outsb               dx, byte ptr gs:[si]
            //   657265               | jb                  0x68
            //   2064656c             | and                 byte ptr [ebp + 0x6c], ah
            //   20636f               | and                 byte ptr [ebx + 0x6f], ah
            //   6d                   | insd                dword ptr es:[edi], dx
            //   7075                 | jo                  0x77

        $sequence_1 = { 6a05 68f3000000 8d45e4 68???????? 50 e8???????? 83c434 }
            // n = 7, score = 100
            //   6a05                 | push                5
            //   68f3000000           | push                0xf3
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c434               | add                 esp, 0x34

        $sequence_2 = { 8d8508faffff 68???????? 50 e8???????? 8d8508f2ffff 50 8d8508faffff }
            // n = 7, score = 100
            //   8d8508faffff         | lea                 eax, [ebp - 0x5f8]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d8508f2ffff         | lea                 eax, [ebp - 0xdf8]
            //   50                   | push                eax
            //   8d8508faffff         | lea                 eax, [ebp - 0x5f8]

        $sequence_3 = { 740a c783ac00000007000000 39bb1c010100 7708 39bb18010100 7666 39bb20010100 }
            // n = 7, score = 100
            //   740a                 | je                  0xc
            //   c783ac00000007000000     | mov    dword ptr [ebx + 0xac], 7
            //   39bb1c010100         | cmp                 dword ptr [ebx + 0x1011c], edi
            //   7708                 | ja                  0xa
            //   39bb18010100         | cmp                 dword ptr [ebx + 0x10118], edi
            //   7666                 | jbe                 0x68
            //   39bb20010100         | cmp                 dword ptr [ebx + 0x10120], edi

        $sequence_4 = { 8365e800 8365ec00 837dfc00 7522 837d0800 740e 8b7d08 }
            // n = 7, score = 100
            //   8365e800             | and                 dword ptr [ebp - 0x18], 0
            //   8365ec00             | and                 dword ptr [ebp - 0x14], 0
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7522                 | jne                 0x24
            //   837d0800             | cmp                 dword ptr [ebp + 8], 0
            //   740e                 | je                  0x10
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]

        $sequence_5 = { 50 8d8538d9ffff 50 e8???????? 8bc3 50 8d8538d9ffff }
            // n = 7, score = 100
            //   50                   | push                eax
            //   8d8538d9ffff         | lea                 eax, [ebp - 0x26c8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bc3                 | mov                 eax, ebx
            //   50                   | push                eax
            //   8d8538d9ffff         | lea                 eax, [ebp - 0x26c8]

        $sequence_6 = { e8???????? 8d4564 50 8d45ec 50 e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8d4564               | lea                 eax, [ebp + 0x64]
            //   50                   | push                eax
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_7 = { 7970 7428 293b 223e 44 657363 69667261723c2f }
            // n = 7, score = 100
            //   7970                 | jns                 0x72
            //   7428                 | je                  0x2a
            //   293b                 | sub                 dword ptr [ebx], edi
            //   223e                 | and                 bh, byte ptr [esi]
            //   44                   | inc                 esp
            //   657363               | jae                 0x66
            //   69667261723c2f       | imul                esp, dword ptr [esi + 0x72], 0x2f3c7261

        $sequence_8 = { 807b1d00 8d45e8 50 7445 ff7308 8365e800 680a202600 }
            // n = 7, score = 100
            //   807b1d00             | cmp                 byte ptr [ebx + 0x1d], 0
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax
            //   7445                 | je                  0x47
            //   ff7308               | push                dword ptr [ebx + 8]
            //   8365e800             | and                 dword ptr [ebp - 0x18], 0
            //   680a202600           | push                0x26200a

        $sequence_9 = { c3 85f6 7504 6a9a 58 c3 8b8608010000 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   85f6                 | test                esi, esi
            //   7504                 | jne                 6
            //   6a9a                 | push                -0x66
            //   58                   | pop                 eax
            //   c3                   | ret                 
            //   8b8608010000         | mov                 eax, dword ptr [esi + 0x108]

    condition:
        7 of them and filesize < 1392640
}