rule win_polyvice_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.polyvice."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.polyvice"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c1c207 4431c2 01ca 4489c9 c1c902 01d6 4189c8 }
            // n = 7, score = 200
            //   c1c207               | dec                 esp
            //   4431c2               | lea                 esp, [ebp + 0x4780]
            //   01ca                 | dec                 esp
            //   4489c9               | mov                 dword ptr [ebp - 0x38], edx
            //   c1c902               | dec                 esp
            //   01d6                 | lea                 edx, [esp + 0x48]
            //   4189c8               | xor                 edx, edx

        $sequence_1 = { 41d1c1 4589ca 4589c1 4109f9 21fd 448954240c 4121c9 }
            // n = 7, score = 200
            //   41d1c1               | lea                 eax, [edx + esi]
            //   4589ca               | inc                 ecx
            //   4589c1               | ror                 edx, 2
            //   4109f9               | inc                 ebp
            //   21fd                 | mov                 esi, edx
            //   448954240c           | inc                 ecx
            //   4121c9               | mov                 edx, ecx

        $sequence_2 = { 4c897c2420 e8???????? 488b0d???????? 4989c4 ffd3 488b2d???????? }
            // n = 6, score = 200
            //   4c897c2420           | ror                 ebx, 0xb
            //   e8????????           |                     
            //   488b0d????????       |                     
            //   4989c4               | inc                 esp
            //   ffd3                 | xor                 ebx, edx
            //   488b2d????????       |                     

        $sequence_3 = { 4489ef c1ef0a 4589d5 31f8 4531dd 01c2 4489e8 }
            // n = 7, score = 200
            //   4489ef               | mov                 dword ptr [esp], eax
            //   c1ef0a               | inc                 esp
            //   4589d5               | mov                 dword ptr [esp + 0x10], edi
            //   31f8                 | inc                 ebp
            //   4531dd               | mov                 edi, esi
            //   01c2                 | movzx               eax, ah
            //   4489e8               | inc                 ecx

        $sequence_4 = { 5b 5e 5f 5d c3 488d0de5a90100 41b804010000 }
            // n = 7, score = 200
            //   5b                   | dec                 eax
            //   5e                   | mov                 dword ptr [esp + 0x358], edx
            //   5f                   | dec                 eax
            //   5d                   | mov                 edx, dword ptr [eax + 0x28]
            //   c3                   | dec                 eax
            //   488d0de5a90100       | mov                 dword ptr [esp + 0x360], edx
            //   41b804010000         | dec                 eax

        $sequence_5 = { 41895120 0fb710 0fb64002 6641895125 41884127 488b443c48 }
            // n = 6, score = 200
            //   41895120             | inc                 ebp
            //   0fb710               | add                 edi, eax
            //   0fb64002             | inc                 esp
            //   6641895125           | mov                 ebp, ecx
            //   41884127             | inc                 ebp
            //   488b443c48           | mov                 ecx, esp

        $sequence_6 = { c1e80a 4131c6 4489d0 4189da 438d143e 21d8 41c1ca06 }
            // n = 7, score = 200
            //   c1e80a               | sub                 esp, 0x28
            //   4131c6               | dec                 eax
            //   4489d0               | lea                 ebx, [0x2674a]
            //   4189da               | dec                 eax
            //   438d143e             | lea                 edi, [0x24363]
            //   21d8                 | push                esi
            //   41c1ca06             | push                ebx

        $sequence_7 = { 4131c0 4521d0 41c1ca02 4131d0 8d942a9979825a 4101c8 4489c9 }
            // n = 7, score = 200
            //   4131c0               | xor                 edx, edx
            //   4521d0               | inc                 ebp
            //   41c1ca02             | mov                 edx, esp
            //   4131d0               | inc                 ecx
            //   8d942a9979825a       | rol                 edx, 7
            //   4101c8               | inc                 ecx
            //   4489c9               | mov                 edx, edx

        $sequence_8 = { 4c8d0526d40000 c1e008 31c3 89f8 c1e818 0fb6d3 458b1c82 }
            // n = 7, score = 200
            //   4c8d0526d40000       | test                al, al
            //   c1e008               | jne                 0x1cd2
            //   31c3                 | cmp                 word ptr [eax], si
            //   89f8                 | dec                 eax
            //   c1e818               | add                 ecx, 1
            //   0fb6d3               | xor                 dl, byte ptr [ecx - 1]
            //   458b1c82             | inc                 ecx

        $sequence_9 = { 664139dc 0f46d9 83c201 0fb7c2 4439f0 7cdc }
            // n = 6, score = 200
            //   664139dc             | rol                 edx, 0xa
            //   0f46d9               | xor                 edi, edx
            //   83c201               | inc                 esp
            //   0fb7c2               | mov                 edx, ecx
            //   4439f0               | inc                 esp
            //   7cdc                 | or                  edx, eax

    condition:
        7 of them and filesize < 369664
}