rule win_portdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.portdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.portdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 884dff eb4e 8808 46 40 eb48 80f909 }
            // n = 7, score = 100
            //   884dff               | mov                 byte ptr [ebp - 1], cl
            //   eb4e                 | jmp                 0x50
            //   8808                 | mov                 byte ptr [eax], cl
            //   46                   | inc                 esi
            //   40                   | inc                 eax
            //   eb48                 | jmp                 0x4a
            //   80f909               | cmp                 cl, 9

        $sequence_1 = { e8???????? 6a5c 58 6a2a 668945f0 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   6a5c                 | push                0x5c
            //   58                   | pop                 eax
            //   6a2a                 | push                0x2a
            //   668945f0             | mov                 word ptr [ebp - 0x10], ax

        $sequence_2 = { 50 a3???????? e8???????? 83c410 8b4dfc 33cd 5e }
            // n = 7, score = 100
            //   50                   | push                eax
            //   a3????????           |                     
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp
            //   5e                   | pop                 esi

        $sequence_3 = { ff75e8 ff15???????? 6828020000 8d85c0fdffff }
            // n = 4, score = 100
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   ff15????????         |                     
            //   6828020000           | push                0x228
            //   8d85c0fdffff         | lea                 eax, [ebp - 0x240]

        $sequence_4 = { 6a64 5a ffb57cf7ffff 668945e0 }
            // n = 4, score = 100
            //   6a64                 | push                0x64
            //   5a                   | pop                 edx
            //   ffb57cf7ffff         | push                dword ptr [ebp - 0x884]
            //   668945e0             | mov                 word ptr [ebp - 0x20], ax

        $sequence_5 = { 8b0485b80f0210 f644010440 7409 803a1a 7504 33c0 eb1c }
            // n = 7, score = 100
            //   8b0485b80f0210       | mov                 eax, dword ptr [eax*4 + 0x10020fb8]
            //   f644010440           | test                byte ptr [ecx + eax + 4], 0x40
            //   7409                 | je                  0xb
            //   803a1a               | cmp                 byte ptr [edx], 0x1a
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax
            //   eb1c                 | jmp                 0x1e

        $sequence_6 = { 59 85c0 0f84da000000 8b4704 8bce 8b7708 c1e102 }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   0f84da000000         | je                  0xe0
            //   8b4704               | mov                 eax, dword ptr [edi + 4]
            //   8bce                 | mov                 ecx, esi
            //   8b7708               | mov                 esi, dword ptr [edi + 8]
            //   c1e102               | shl                 ecx, 2

        $sequence_7 = { 807e0400 0f8564ffffff eb0c ff36 ff15???????? c6460400 5f }
            // n = 7, score = 100
            //   807e0400             | cmp                 byte ptr [esi + 4], 0
            //   0f8564ffffff         | jne                 0xffffff6a
            //   eb0c                 | jmp                 0xe
            //   ff36                 | push                dword ptr [esi]
            //   ff15????????         |                     
            //   c6460400             | mov                 byte ptr [esi + 4], 0
            //   5f                   | pop                 edi

        $sequence_8 = { 85ff 7450 8d4701 50 }
            // n = 4, score = 100
            //   85ff                 | test                edi, edi
            //   7450                 | je                  0x52
            //   8d4701               | lea                 eax, [edi + 1]
            //   50                   | push                eax

        $sequence_9 = { e8???????? a1???????? 33c5 8945fc 53 8b5d08 8d85fdfbffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   53                   | push                ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8d85fdfbffff         | lea                 eax, [ebp - 0x403]

    condition:
        7 of them and filesize < 297984
}