rule win_poscardstealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.poscardstealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.poscardstealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b5610 8955e4 8b4614 8945e8 897e10 897e14 837dcc10 }
            // n = 7, score = 200
            //   8b5610               | mov                 edx, dword ptr [esi + 0x10]
            //   8955e4               | mov                 dword ptr [ebp - 0x1c], edx
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   897e10               | mov                 dword ptr [esi + 0x10], edi
            //   897e14               | mov                 dword ptr [esi + 0x14], edi
            //   837dcc10             | cmp                 dword ptr [ebp - 0x34], 0x10

        $sequence_1 = { 6aff 6a00 50 8bce c645fc02 e8???????? 837de810 }
            // n = 7, score = 200
            //   6aff                 | push                -1
            //   6a00                 | push                0
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   c645fc02             | mov                 byte ptr [ebp - 4], 2
            //   e8????????           |                     
            //   837de810             | cmp                 dword ptr [ebp - 0x18], 0x10

        $sequence_2 = { e8???????? 83c404 397de8 0f82f6000000 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   397de8               | cmp                 dword ptr [ebp - 0x18], edi
            //   0f82f6000000         | jb                  0xfc

        $sequence_3 = { 51 e8???????? 83c420 50 8d8d74ffffff }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20
            //   50                   | push                eax
            //   8d8d74ffffff         | lea                 ecx, [ebp - 0x8c]

        $sequence_4 = { 8901 c9 c3 3b0d???????? 7502 }
            // n = 5, score = 200
            //   8901                 | mov                 dword ptr [ecx], eax
            //   c9                   | leave               
            //   c3                   | ret                 
            //   3b0d????????         |                     
            //   7502                 | jne                 4

        $sequence_5 = { 8bbd90edffff 40 898570edffff 3bc7 0f8ceffbffff 8b0d???????? }
            // n = 6, score = 200
            //   8bbd90edffff         | mov                 edi, dword ptr [ebp - 0x1270]
            //   40                   | inc                 eax
            //   898570edffff         | mov                 dword ptr [ebp - 0x1290], eax
            //   3bc7                 | cmp                 eax, edi
            //   0f8ceffbffff         | jl                  0xfffffbf5
            //   8b0d????????         |                     

        $sequence_6 = { 7305 83c8ff eb08 33c0 83fe01 0f95c0 3bc7 }
            // n = 7, score = 200
            //   7305                 | jae                 7
            //   83c8ff               | or                  eax, 0xffffffff
            //   eb08                 | jmp                 0xa
            //   33c0                 | xor                 eax, eax
            //   83fe01               | cmp                 esi, 1
            //   0f95c0               | setne               al
            //   3bc7                 | cmp                 eax, edi

        $sequence_7 = { 8d45f4 64a300000000 8b35???????? c745fc00000000 8975ac 3b35???????? }
            // n = 6, score = 200
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8b35????????         |                     
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8975ac               | mov                 dword ptr [ebp - 0x54], esi
            //   3b35????????         |                     

        $sequence_8 = { c645fc01 e8???????? 6aff 40 50 8d559c 52 }
            // n = 7, score = 200
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   e8????????           |                     
            //   6aff                 | push                -1
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   8d559c               | lea                 edx, [ebp - 0x64]
            //   52                   | push                edx

        $sequence_9 = { c645fc0e e8???????? c645fc05 397de8 720c 8b4dd4 51 }
            // n = 7, score = 200
            //   c645fc0e             | mov                 byte ptr [ebp - 4], 0xe
            //   e8????????           |                     
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5
            //   397de8               | cmp                 dword ptr [ebp - 0x18], edi
            //   720c                 | jb                  0xe
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 362496
}