rule win_poweliks_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.poweliks."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.poweliks"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3bce 7602 8bce 85c9 7415 8b7d08 8b720c }
            // n = 7, score = 200
            //   3bce                 | cmp                 ecx, esi
            //   7602                 | jbe                 4
            //   8bce                 | mov                 ecx, esi
            //   85c9                 | test                ecx, ecx
            //   7415                 | je                  0x17
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8b720c               | mov                 esi, dword ptr [edx + 0xc]

        $sequence_1 = { 394df4 72cd 8b703c 03f0 8b8e80000000 837c010c00 7449 }
            // n = 7, score = 200
            //   394df4               | cmp                 dword ptr [ebp - 0xc], ecx
            //   72cd                 | jb                  0xffffffcf
            //   8b703c               | mov                 esi, dword ptr [eax + 0x3c]
            //   03f0                 | add                 esi, eax
            //   8b8e80000000         | mov                 ecx, dword ptr [esi + 0x80]
            //   837c010c00           | cmp                 dword ptr [ecx + eax + 0xc], 0
            //   7449                 | je                  0x4b

        $sequence_2 = { ff55f0 8b7508 8b9e40110000 81c604110000 6a40 6800300000 03de }
            // n = 7, score = 200
            //   ff55f0               | call                dword ptr [ebp - 0x10]
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b9e40110000         | mov                 ebx, dword ptr [esi + 0x1140]
            //   81c604110000         | add                 esi, 0x1104
            //   6a40                 | push                0x40
            //   6800300000           | push                0x3000
            //   03de                 | add                 ebx, esi

        $sequence_3 = { 55 8bec 83ec68 6a6b 58 6a65 66894598 }
            // n = 7, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec68               | sub                 esp, 0x68
            //   6a6b                 | push                0x6b
            //   58                   | pop                 eax
            //   6a65                 | push                0x65
            //   66894598             | mov                 word ptr [ebp - 0x68], ax

        $sequence_4 = { 6a6b 58 6a65 66894598 58 }
            // n = 5, score = 200
            //   6a6b                 | push                0x6b
            //   58                   | pop                 eax
            //   6a65                 | push                0x65
            //   66894598             | mov                 word ptr [ebp - 0x68], ax
            //   58                   | pop                 eax

        $sequence_5 = { 51 ff15???????? 8945f8 8d45f8 50 ff15???????? 33d2 }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   33d2                 | xor                 edx, edx

        $sequence_6 = { 8b0c87 0fb70443 8b3486 8365fc00 03ca 894df4 }
            // n = 6, score = 200
            //   8b0c87               | mov                 ecx, dword ptr [edi + eax*4]
            //   0fb70443             | movzx               eax, word ptr [ebx + eax*2]
            //   8b3486               | mov                 esi, dword ptr [esi + eax*4]
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   03ca                 | add                 ecx, edx
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx

        $sequence_7 = { 58 6a72 6689459a 58 6a6e 6689459c 58 }
            // n = 7, score = 200
            //   58                   | pop                 eax
            //   6a72                 | push                0x72
            //   6689459a             | mov                 word ptr [ebp - 0x66], ax
            //   58                   | pop                 eax
            //   6a6e                 | push                0x6e
            //   6689459c             | mov                 word ptr [ebp - 0x64], ax
            //   58                   | pop                 eax

        $sequence_8 = { 47 83ff0c 72ea 83ff0c }
            // n = 4, score = 200
            //   47                   | inc                 edi
            //   83ff0c               | cmp                 edi, 0xc
            //   72ea                 | jb                  0xffffffec
            //   83ff0c               | cmp                 edi, 0xc

        $sequence_9 = { 8b5df4 03d8 8a4405d0 3a441dd0 }
            // n = 4, score = 200
            //   8b5df4               | mov                 ebx, dword ptr [ebp - 0xc]
            //   03d8                 | add                 ebx, eax
            //   8a4405d0             | mov                 al, byte ptr [ebp + eax - 0x30]
            //   3a441dd0             | cmp                 al, byte ptr [ebp + ebx - 0x30]

    condition:
        7 of them and filesize < 115712
}