rule win_powerduke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.powerduke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.powerduke"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8401030000 8945bc 6a00 6800400000 68???????? ff75bc ff15???????? }
            // n = 7, score = 500
            //   0f8401030000         | je                  0x307
            //   8945bc               | mov                 dword ptr [ebp - 0x44], eax
            //   6a00                 | push                0
            //   6800400000           | push                0x4000
            //   68????????           |                     
            //   ff75bc               | push                dword ptr [ebp - 0x44]
            //   ff15????????         |                     

        $sequence_1 = { ebea ad 89c2 81fa68747470 0f8586010000 }
            // n = 5, score = 500
            //   ebea                 | jmp                 0xffffffec
            //   ad                   | lodsd               eax, dword ptr [esi]
            //   89c2                 | mov                 edx, eax
            //   81fa68747470         | cmp                 edx, 0x70747468
            //   0f8586010000         | jne                 0x18c

        $sequence_2 = { 681b000200 6a00 68???????? 6801000080 ff15???????? 09c0 0f8597000000 }
            // n = 7, score = 500
            //   681b000200           | push                0x2001b
            //   6a00                 | push                0
            //   68????????           |                     
            //   6801000080           | push                0x80000001
            //   ff15????????         |                     
            //   09c0                 | or                  eax, eax
            //   0f8597000000         | jne                 0x9d

        $sequence_3 = { 7518 8d85f4f7ffff 6800040000 50 ff35???????? ff15???????? 8d85f4f7ffff }
            // n = 7, score = 500
            //   7518                 | jne                 0x1a
            //   8d85f4f7ffff         | lea                 eax, [ebp - 0x80c]
            //   6800040000           | push                0x400
            //   50                   | push                eax
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   8d85f4f7ffff         | lea                 eax, [ebp - 0x80c]

        $sequence_4 = { 6a00 ff35???????? ff15???????? c705????????00000000 837dfc01 }
            // n = 5, score = 500
            //   6a00                 | push                0
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   c705????????00000000     |     
            //   837dfc01             | cmp                 dword ptr [ebp - 4], 1

        $sequence_5 = { 55 ff15???????? 5a 59 }
            // n = 4, score = 500
            //   55                   | push                ebp
            //   ff15????????         |                     
            //   5a                   | pop                 edx
            //   59                   | pop                 ecx

        $sequence_6 = { c745fc01000000 eb11 c745d001000000 8b451c }
            // n = 4, score = 500
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1
            //   eb11                 | jmp                 0x13
            //   c745d001000000       | mov                 dword ptr [ebp - 0x30], 1
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]

        $sequence_7 = { 7403 41 ebf1 c6040e00 51 }
            // n = 5, score = 500
            //   7403                 | je                  5
            //   41                   | inc                 ecx
            //   ebf1                 | jmp                 0xfffffff3
            //   c6040e00             | mov                 byte ptr [esi + ecx], 0
            //   51                   | push                ecx

        $sequence_8 = { 7419 a3???????? ff7514 50 ff15???????? c705????????01000000 31c0 }
            // n = 7, score = 500
            //   7419                 | je                  0x1b
            //   a3????????           |                     
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   c705????????01000000     |     
            //   31c0                 | xor                 eax, eax

        $sequence_9 = { ff75e4 ff15???????? ff75c4 ff15???????? }
            // n = 4, score = 500
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   ff15????????         |                     
            //   ff75c4               | push                dword ptr [ebp - 0x3c]
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 57344
}