rule win_powerloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.powerloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.powerloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8b7c2430 85ed 740d }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8b7c2430             | movzx               eax, byte ptr [esp + 0x4d8]
            //   85ed                 | dec                 eax
            //   740d                 | mov                 edx, edi

        $sequence_1 = { e8???????? eb22 33c9 66666666660f1f840000000000 0fb6840c30010000 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   eb22                 | je                  0xd1b
            //   33c9                 | dec                 esp
            //   66666666660f1f840000000000     | lea    eax, [0x1f0b]
            //   0fb6840c30010000     | dec                 eax

        $sequence_2 = { 33d2 ff15???????? 83f81f 7323 }
            // n = 4, score = 300
            //   33d2                 | dec                 eax
            //   ff15????????         |                     
            //   83f81f               | lea                 edx, [0x1ad7]
            //   7323                 | inc                 ebp

        $sequence_3 = { 7441 8b5c2430 85db 741d }
            // n = 4, score = 300
            //   7441                 | lea                 ecx, [esp + 0x130]
            //   8b5c2430             | test                al, al
            //   85db                 | je                  0x2cd
            //   741d                 | dec                 eax

        $sequence_4 = { 8bd0 e8???????? 85ff 740c }
            // n = 4, score = 300
            //   8bd0                 | je                  0x65
            //   e8????????           |                     
            //   85ff                 | inc                 ebp
            //   740c                 | xor                 ecx, ecx

        $sequence_5 = { e8???????? 0fb6d8 84c0 7514 ff15???????? }
            // n = 5, score = 300
            //   e8????????           |                     
            //   0fb6d8               | lea                 eax, [esp + 0x448]
            //   84c0                 | dec                 eax
            //   7514                 | lea                 edx, [0x1065]
            //   ff15????????         |                     

        $sequence_6 = { e8???????? 0fb6d8 84c0 7514 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   0fb6d8               | je                  0x8cf
            //   84c0                 | mov                 bl, al
            //   7514                 | test                bl, bl

        $sequence_7 = { eb22 33c9 66666666660f1f840000000000 0fb6840c30010000 }
            // n = 4, score = 300
            //   eb22                 | lea                 edx, [0x3855]
            //   33c9                 | mov                 ebp, esp
            //   66666666660f1f840000000000     | push    ebx
            //   0fb6840c30010000     | push                eax

        $sequence_8 = { e8???????? eb22 33c9 66666666660f1f840000000000 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   eb22                 | mov                 ebx, ecx
            //   33c9                 | dec                 eax
            //   66666666660f1f840000000000     | lea    edx, [0x2cc2]

        $sequence_9 = { 33d2 c605????????00 e8???????? 0fb6c3 }
            // n = 4, score = 300
            //   33d2                 | dec                 eax
            //   c605????????00       |                     
            //   e8????????           |                     
            //   0fb6c3               | mov                 dword ptr [esp + 0x30], eax

    condition:
        7 of them and filesize < 155648
}