rule win_powershellrunner_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.powershellrunner."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.powershellrunner"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c684243e02000036 c684243f02000014 c684244002000031 c684244102000031 }
            // n = 4, score = 200
            //   c684243e02000036     | mov                 eax, dword ptr [esp + 0x34]
            //   c684243f02000014     | inc                 eax
            //   c684244002000031     | dec                 eax
            //   c684244102000031     | cwde                

        $sequence_1 = { 488bd3 488d0d0f440200 e8???????? 33c9 85c0 480f44cb }
            // n = 6, score = 200
            //   488bd3               | dec                 eax
            //   488d0d0f440200       | mov                 dword ptr [esp + 0x20], 0
            //   e8????????           |                     
            //   33c9                 | inc                 ebp
            //   85c0                 | xor                 ecx, ecx
            //   480f44cb             | inc                 ebp

        $sequence_2 = { 488d4c2450 e8???????? ba05000000 488d4c2448 e8???????? ba06000000 }
            // n = 6, score = 200
            //   488d4c2450           | dec                 eax
            //   e8????????           |                     
            //   ba05000000           | cmp                 dword ptr [esp + 0x20], 0
            //   488d4c2448           | jne                 0xac9
            //   e8????????           |                     
            //   ba06000000           | inc                 ebp

        $sequence_3 = { b872000000 6689842452010000 b872000000 6689842454010000 b865000000 6689842456010000 }
            // n = 6, score = 200
            //   b872000000           | mov                 dword ptr [esp + 0xd8], 0xfffffffe
            //   6689842452010000     | dec                 eax
            //   b872000000           | xor                 eax, esp
            //   6689842454010000     | dec                 eax
            //   b865000000           | mov                 dword ptr [esp + 0x100], eax
            //   6689842456010000     | dec                 eax

        $sequence_4 = { 8b442440 8b4c2444 03c8 8bc1 8bc8 ff15???????? 8b442424 }
            // n = 7, score = 200
            //   8b442440             | dec                 eax
            //   8b4c2444             | mov                 ecx, edx
            //   03c8                 | inc                 esp
            //   8bc1                 | movzx               ecx, byte ptr [esp + 0x68]
            //   8bc8                 | dec                 esp
            //   ff15????????         |                     
            //   8b442424             | mov                 eax, dword ptr [esp + 0x60]

        $sequence_5 = { 488d4c2428 e8???????? 89442420 837c242000 7418 }
            // n = 5, score = 200
            //   488d4c2428           | inc                 ebp
            //   e8????????           |                     
            //   89442420             | xor                 ecx, ecx
            //   837c242000           | inc                 ebp
            //   7418                 | xor                 eax, eax

        $sequence_6 = { 4889442428 eb1c 488b442420 4883c002 4889442420 488b442428 4883c002 }
            // n = 7, score = 200
            //   4889442428           | jne                 0x108c
            //   eb1c                 | jmp                 0x1106
            //   488b442420           | dec                 eax
            //   4883c002             | mov                 ecx, dword ptr [esp + 0x90]
            //   4889442420           | dec                 eax
            //   488b442428           | mov                 eax, dword ptr [esp + 0x20]
            //   4883c002             | dec                 eax

        $sequence_7 = { 4c8b442438 488d542420 488d4c2460 e8???????? 0fb6c0 85c0 7415 }
            // n = 7, score = 200
            //   4c8b442438           | dec                 eax
            //   488d542420           | mov                 ecx, dword ptr [esp + 0x330]
            //   488d4c2460           | dec                 eax
            //   e8????????           |                     
            //   0fb6c0               | mov                 dword ptr [ecx + 0x190], eax
            //   85c0                 | dec                 eax
            //   7415                 | lea                 edx, [esp + 0x248]

        $sequence_8 = { 7363 488bf3 4c8d351b770100 83e63f 488beb 48c1fd06 48c1e606 }
            // n = 7, score = 200
            //   7363                 | mov                 ecx, dword ptr [esp + 0x28]
            //   488bf3               | call                dword ptr [eax + 0x10]
            //   4c8d351b770100       | dec                 eax
            //   83e63f               | cmp                 dword ptr [esp + 0x30], 0
            //   488beb               | je                  0x1d2d
            //   48c1fd06             | dec                 eax
            //   48c1e606             | mov                 ecx, dword ptr [esp + 0x30]

        $sequence_9 = { 488bc8 e8???????? 4c8d442440 488bd0 488b4c2448 e8???????? 488b842490000000 }
            // n = 7, score = 200
            //   488bc8               | mov                 word ptr [esp + 0x172], ax
            //   e8????????           |                     
            //   4c8d442440           | dec                 eax
            //   488bd0               | xor                 eax, esp
            //   488b4c2448           | dec                 eax
            //   e8????????           |                     
            //   488b842490000000     | mov                 dword ptr [esp + 0xa8], eax

    condition:
        7 of them and filesize < 458752
}