rule win_powersniff_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.powersniff."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.powersniff"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b5dec ff75fc e8???????? 8bd8 3bde }
            // n = 5, score = 100
            //   8b5dec               | mov                 ebx, dword ptr [ebp - 0x14]
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   8bd8                 | mov                 ebx, eax
            //   3bde                 | cmp                 ebx, esi

        $sequence_1 = { 894df4 33ff eb08 3c0d 7408 47 }
            // n = 6, score = 100
            //   894df4               | mov                 dword ptr [ebp - 0xc], ecx
            //   33ff                 | xor                 edi, edi
            //   eb08                 | jmp                 0xa
            //   3c0d                 | cmp                 al, 0xd
            //   7408                 | je                  0xa
            //   47                   | inc                 edi

        $sequence_2 = { c745e04d9b0010 c745e46f910010 c745e8a2910010 c745ec549b0010 c745f0c2910010 }
            // n = 5, score = 100
            //   c745e04d9b0010       | mov                 dword ptr [ebp - 0x20], 0x10009b4d
            //   c745e46f910010       | mov                 dword ptr [ebp - 0x1c], 0x1000916f
            //   c745e8a2910010       | mov                 dword ptr [ebp - 0x18], 0x100091a2
            //   c745ec549b0010       | mov                 dword ptr [ebp - 0x14], 0x10009b54
            //   c745f0c2910010       | mov                 dword ptr [ebp - 0x10], 0x100091c2

        $sequence_3 = { 8b4508 56 be???????? 57 8908 8a03 894dfc }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   be????????           |                     
            //   57                   | push                edi
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8a03                 | mov                 al, byte ptr [ebx]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx

        $sequence_4 = { 8975ec 8b75f4 c1ee18 8b34b590740010 }
            // n = 4, score = 100
            //   8975ec               | mov                 dword ptr [ebp - 0x14], esi
            //   8b75f4               | mov                 esi, dword ptr [ebp - 0xc]
            //   c1ee18               | shr                 esi, 0x18
            //   8b34b590740010       | mov                 esi, dword ptr [esi*4 + 0x10007490]

        $sequence_5 = { eb12 c745fc08000000 eb09 ff15???????? 8945fc 8b45fc 5f }
            // n = 7, score = 100
            //   eb12                 | jmp                 0x14
            //   c745fc08000000       | mov                 dword ptr [ebp - 4], 8
            //   eb09                 | jmp                 0xb
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   5f                   | pop                 edi

        $sequence_6 = { 33db 43 5e 5f ff75fc ff15???????? ff75f0 }
            // n = 7, score = 100
            //   33db                 | xor                 ebx, ebx
            //   43                   | inc                 ebx
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ff15????????         |                     
            //   ff75f0               | push                dword ptr [ebp - 0x10]

        $sequence_7 = { 750f ff15???????? 3de5030000 750d eb09 ff7610 }
            // n = 6, score = 100
            //   750f                 | jne                 0x11
            //   ff15????????         |                     
            //   3de5030000           | cmp                 eax, 0x3e5
            //   750d                 | jne                 0xf
            //   eb09                 | jmp                 0xb
            //   ff7610               | push                dword ptr [esi + 0x10]

        $sequence_8 = { ff15???????? 8bf8 897df0 3bfb 7435 8d4508 50 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   897df0               | mov                 dword ptr [ebp - 0x10], edi
            //   3bfb                 | cmp                 edi, ebx
            //   7435                 | je                  0x37
            //   8d4508               | lea                 eax, [ebp + 8]
            //   50                   | push                eax

        $sequence_9 = { 331cb590840010 c1ea18 8b349590780010 8b55f4 335808 c1ea08 }
            // n = 6, score = 100
            //   331cb590840010       | xor                 ebx, dword ptr [esi*4 + 0x10008490]
            //   c1ea18               | shr                 edx, 0x18
            //   8b349590780010       | mov                 esi, dword ptr [edx*4 + 0x10007890]
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   335808               | xor                 ebx, dword ptr [eax + 8]
            //   c1ea08               | shr                 edx, 8

    condition:
        7 of them and filesize < 90112
}