rule win_predator_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.predator."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.predator"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 8bf1 8d4dfd 57 6a0a }
            // n = 5, score = 800
            //   56                   | push                esi
            //   8bf1                 | mov                 esi, ecx
            //   8d4dfd               | lea                 ecx, [ebp - 3]
            //   57                   | push                edi
            //   6a0a                 | push                0xa

        $sequence_1 = { 395dec 7508 83c8ff e9???????? ff75ec e8???????? }
            // n = 6, score = 800
            //   395dec               | cmp                 dword ptr [ebp - 0x14], ebx
            //   7508                 | jne                 0xa
            //   83c8ff               | or                  eax, 0xffffffff
            //   e9????????           |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     

        $sequence_2 = { 50 8bcf e8???????? e9???????? 0f2805???????? }
            // n = 5, score = 800
            //   50                   | push                eax
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   e9????????           |                     
            //   0f2805????????       |                     

        $sequence_3 = { 7316 8a440dc7 32c2 88440dc7 41 }
            // n = 5, score = 800
            //   7316                 | jae                 0x18
            //   8a440dc7             | mov                 al, byte ptr [ebp + ecx - 0x39]
            //   32c2                 | xor                 al, dl
            //   88440dc7             | mov                 byte ptr [ebp + ecx - 0x39], al
            //   41                   | inc                 ecx

        $sequence_4 = { 83c8ff e9???????? ff75ec e8???????? 59 8bf0 }
            // n = 6, score = 800
            //   83c8ff               | or                  eax, 0xffffffff
            //   e9????????           |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8bf0                 | mov                 esi, eax

        $sequence_5 = { 0fa2 8906 895e04 894e08 89560c 834dfcff 8b4df4 }
            // n = 7, score = 800
            //   0fa2                 | cpuid               
            //   8906                 | mov                 dword ptr [esi], eax
            //   895e04               | mov                 dword ptr [esi + 4], ebx
            //   894e08               | mov                 dword ptr [esi + 8], ecx
            //   89560c               | mov                 dword ptr [esi + 0xc], edx
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_6 = { 8b00 57 03c2 8bce 50 e8???????? 5f }
            // n = 7, score = 800
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   57                   | push                edi
            //   03c2                 | add                 eax, edx
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   5f                   | pop                 edi

        $sequence_7 = { 8906 895e04 894e08 89560c 834dfcff 8b4df4 }
            // n = 6, score = 800
            //   8906                 | mov                 dword ptr [esi], eax
            //   895e04               | mov                 dword ptr [esi + 4], ebx
            //   894e08               | mov                 dword ptr [esi + 8], ecx
            //   89560c               | mov                 dword ptr [esi + 0xc], edx
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_8 = { 395dec 7508 83c8ff e9???????? ff75ec e8???????? 59 }
            // n = 7, score = 800
            //   395dec               | cmp                 dword ptr [ebp - 0x14], ebx
            //   7508                 | jne                 0xa
            //   83c8ff               | or                  eax, 0xffffffff
            //   e9????????           |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_9 = { ff750c 8bf1 8d4dfd ff7508 }
            // n = 4, score = 800
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8bf1                 | mov                 esi, ecx
            //   8d4dfd               | lea                 ecx, [ebp - 3]
            //   ff7508               | push                dword ptr [ebp + 8]

    condition:
        7 of them and filesize < 2211840
}