rule win_proto8_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.proto8_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.proto8_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b5a10 8b4210 83c308 83e3fa a801 7421 8b4210 }
            // n = 7, score = 100
            //   8b5a10               | ja                  0x236
            //   8b4210               | dec                 eax
            //   83c308               | mov                 eax, edi
            //   83e3fa               | dec                 eax
            //   a801                 | cmp                 dword ptr [edi + 0x18], 0x10
            //   7421                 | jb                  0x22c
            //   8b4210               | mov                 edx, dword ptr [ebx]

        $sequence_1 = { ba80000000 e8???????? c70302000000 4c8b8320010000 488d4318 488b9328010000 33f6 }
            // n = 7, score = 100
            //   ba80000000           | mov                 edx, 0x48
            //   e8????????           |                     
            //   c70302000000         | dec                 eax
            //   4c8b8320010000       | mov                 ecx, dword ptr [edi]
            //   488d4318             | dec                 eax
            //   488b9328010000       | mov                 ebx, dword ptr [esp + 0x40]
            //   33f6                 | dec                 eax

        $sequence_2 = { 837c244801 0f8595000000 488b6c2458 8b7b30 488b4b48 488b01 ff5008 }
            // n = 7, score = 100
            //   837c244801           | cmp                 cl, 0xd
            //   0f8595000000         | jne                 0x720
            //   488b6c2458           | dec                 esi
            //   8b7b30               | dec                 eax
            //   488b4b48             | sub                 eax, 1
            //   488b01               | jne                 0x706
            //   ff5008               | cmp                 cl, 0xa

        $sequence_3 = { 7468 3bca 8bc1 0f46c2 ffc0 4103c0 3bf0 }
            // n = 7, score = 100
            //   7468                 | cmp                 eax, esi
            //   3bca                 | jne                 0x3bc
            //   8bc1                 | je                  0x400
            //   0f46c2               | inc                 esp
            //   ffc0                 | movzx               edx, word ptr [eax]
            //   4103c0               | inc                 ebp
            //   3bf0                 | xor                 ebx, ebx

        $sequence_4 = { 89531c 48873cc8 4885ff 7506 8d4201 89431c 40f6c701 }
            // n = 7, score = 100
            //   89531c               | mov                 dword ptr [ebp - 0x39], eax
            //   48873cc8             | test                al, al
            //   4885ff               | inc                 eax
            //   7506                 | movzx               edi, bh
            //   8d4201               | mov                 eax, 1
            //   89431c               | mov                 dword ptr [ebp - 0x44], eax
            //   40f6c701             | dec                 ecx

        $sequence_5 = { e8???????? 448bf0 e9???????? 4c8b86a8000000 488d8e88000000 488b96b0000000 4d8bcd }
            // n = 7, score = 100
            //   e8????????           |                     
            //   448bf0               | cmp                 dword ptr [ebp + 0x60], ebp
            //   e9????????           |                     
            //   4c8b86a8000000       | inc                 ecx
            //   488d8e88000000       | mov                 eax, 0xfe
            //   488b96b0000000       | dec                 eax
            //   4d8bcd               | lea                 edx, [0x5d538]

        $sequence_6 = { 7636 66660f1f840000000000 8bc8 48c1e106 428b541124 85d2 }
            // n = 6, score = 100
            //   7636                 | mov                 eax, dword ptr [ecx + eax*8]
            //   66660f1f840000000000     | dec    ecx
            //   8bc8                 | arpl                word ptr [eax + 0xa0], dx
            //   48c1e106             | dec                 eax
            //   428b541124           | dec                 edx
            //   85d2                 | jne                 0x1d8

        $sequence_7 = { 8b8b64810100 897dd4 897de4 897df4 488b8378810100 488d55b0 }
            // n = 6, score = 100
            //   8b8b64810100         | cmp                 dword ptr [esi + 0x28], eax
            //   897dd4               | jne                 0x1229
            //   897de4               | dec                 eax
            //   897df4               | mov                 ecx, dword ptr [esi + 0x20]
            //   488b8378810100       | dec                 eax
            //   488d55b0             | mov                 eax, 0xffffffff

        $sequence_8 = { 83e801 7455 83e801 743d 83e801 740a 83f801 }
            // n = 7, score = 100
            //   83e801               | and                 dword ptr [esp + 0x60], 0
            //   7455                 | dec                 ecx
            //   83e801               | mov                 edx, ebp
            //   743d                 | and                 dword ptr [ebp - 0x70], 0
            //   83e801               | dec                 eax
            //   740a                 | mov                 dword ptr [esp + 0x58], ecx
            //   83f801               | dec                 eax

        $sequence_9 = { 8b4318 3bc8 0f8e96000000 488b4b38 48894c2450 e8???????? }
            // n = 6, score = 100
            //   8b4318               | mov                 dword ptr [ebx + 0xb0], esi
            //   3bc8                 | dec                 eax
            //   0f8e96000000         | mov                 edi, eax
            //   488b4b38             | dec                 eax
            //   48894c2450           | mov                 eax, dword ptr [eax + 0x40]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 2537472
}