rule win_protonbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.protonbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.protonbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? ffb5f4feffff ff15???????? 8d8dfcfeffff }
            // n = 4, score = 400
            //   ff15????????         |                     
            //   ffb5f4feffff         | push                dword ptr [ebp - 0x10c]
            //   ff15????????         |                     
            //   8d8dfcfeffff         | lea                 ecx, [ebp - 0x104]

        $sequence_1 = { ffd3 85ff 8bbdf4fffeff 7f8d 5e }
            // n = 5, score = 400
            //   ffd3                 | call                ebx
            //   85ff                 | test                edi, edi
            //   8bbdf4fffeff         | mov                 edi, dword ptr [ebp - 0x1000c]
            //   7f8d                 | jg                  0xffffff8f
            //   5e                   | pop                 esi

        $sequence_2 = { 51 52 8d8da4feffff e8???????? 6a00 6aff 6a00 }
            // n = 7, score = 400
            //   51                   | push                ecx
            //   52                   | push                edx
            //   8d8da4feffff         | lea                 ecx, [ebp - 0x15c]
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6aff                 | push                -1
            //   6a00                 | push                0

        $sequence_3 = { 83bda0feffff10 8d8d8cfeffff 56 0f438d8cfeffff 6a00 51 6a00 }
            // n = 7, score = 400
            //   83bda0feffff10       | cmp                 dword ptr [ebp - 0x160], 0x10
            //   8d8d8cfeffff         | lea                 ecx, [ebp - 0x174]
            //   56                   | push                esi
            //   0f438d8cfeffff       | cmovae              ecx, dword ptr [ebp - 0x174]
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   6a00                 | push                0

        $sequence_4 = { 6a00 8b18 899df8fffeff e8???????? 83c410 }
            // n = 5, score = 400
            //   6a00                 | push                0
            //   8b18                 | mov                 ebx, dword ptr [eax]
            //   899df8fffeff         | mov                 dword ptr [ebp - 0x10008], ebx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_5 = { ff7508 e8???????? 83c410 5d c3 6a1c b8???????? }
            // n = 7, score = 400
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   6a1c                 | push                0x1c
            //   b8????????           |                     

        $sequence_6 = { 57 50 8d45f4 64a300000000 8d8dbcfeffff e8???????? }
            // n = 6, score = 400
            //   57                   | push                edi
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8d8dbcfeffff         | lea                 ecx, [ebp - 0x144]
            //   e8????????           |                     

        $sequence_7 = { 837e1410 8955a0 8bc6 7202 8b06 8d1438 8b45a0 }
            // n = 7, score = 400
            //   837e1410             | cmp                 dword ptr [esi + 0x14], 0x10
            //   8955a0               | mov                 dword ptr [ebp - 0x60], edx
            //   8bc6                 | mov                 eax, esi
            //   7202                 | jb                  4
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8d1438               | lea                 edx, [eax + edi]
            //   8b45a0               | mov                 eax, dword ptr [ebp - 0x60]

        $sequence_8 = { e8???????? 83c418 c645fc01 8d85bcfeffff }
            // n = 4, score = 400
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   8d85bcfeffff         | lea                 eax, [ebp - 0x144]

        $sequence_9 = { ff15???????? 56 85c0 7404 ffd7 eb02 ffd3 }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   56                   | push                esi
            //   85c0                 | test                eax, eax
            //   7404                 | je                  6
            //   ffd7                 | call                edi
            //   eb02                 | jmp                 4
            //   ffd3                 | call                ebx

    condition:
        7 of them and filesize < 1073152
}