rule win_pseudo_manuscrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pseudo_manuscrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pseudo_manuscrypt"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b45ec 8d044502000000 a3???????? 8b4dfc 33cd e8???????? 8be5 }
            // n = 7, score = 200
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8d044502000000       | lea                 eax, [eax*2 + 2]
            //   a3????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     
            //   8be5                 | mov                 esp, ebp

        $sequence_1 = { 8b8594feffff 8d8df0feffff 8b9ddcfeffff 8bbdd8feffff 99 03c3 898de4feffff }
            // n = 7, score = 200
            //   8b8594feffff         | mov                 eax, dword ptr [ebp - 0x16c]
            //   8d8df0feffff         | lea                 ecx, [ebp - 0x110]
            //   8b9ddcfeffff         | mov                 ebx, dword ptr [ebp - 0x124]
            //   8bbdd8feffff         | mov                 edi, dword ptr [ebp - 0x128]
            //   99                   | cdq                 
            //   03c3                 | add                 eax, ebx
            //   898de4feffff         | mov                 dword ptr [ebp - 0x11c], ecx

        $sequence_2 = { 8bf8 ff15???????? 5e 8bc7 5f 5b 8be5 }
            // n = 7, score = 200
            //   8bf8                 | mov                 edi, eax
            //   ff15????????         |                     
            //   5e                   | pop                 esi
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp

        $sequence_3 = { 50 e8???????? 83c404 c70700000000 8b07 c7470800000000 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   c70700000000         | mov                 dword ptr [edi], 0
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   c7470800000000       | mov                 dword ptr [edi + 8], 0

        $sequence_4 = { eb6b 8d45a0 50 8d4d8c e8???????? 8b4dc0 85c9 }
            // n = 7, score = 200
            //   eb6b                 | jmp                 0x6d
            //   8d45a0               | lea                 eax, [ebp - 0x60]
            //   50                   | push                eax
            //   8d4d8c               | lea                 ecx, [ebp - 0x74]
            //   e8????????           |                     
            //   8b4dc0               | mov                 ecx, dword ptr [ebp - 0x40]
            //   85c9                 | test                ecx, ecx

        $sequence_5 = { 8bec 83ec14 57 8d45ec c745ec14000000 50 8bf9 }
            // n = 7, score = 200
            //   8bec                 | mov                 ebp, esp
            //   83ec14               | sub                 esp, 0x14
            //   57                   | push                edi
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   c745ec14000000       | mov                 dword ptr [ebp - 0x14], 0x14
            //   50                   | push                eax
            //   8bf9                 | mov                 edi, ecx

        $sequence_6 = { 7407 b801000000 5e c3 8b86c0000000 85c0 7411 }
            // n = 7, score = 200
            //   7407                 | je                  9
            //   b801000000           | mov                 eax, 1
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   8b86c0000000         | mov                 eax, dword ptr [esi + 0xc0]
            //   85c0                 | test                eax, eax
            //   7411                 | je                  0x13

        $sequence_7 = { 390d???????? 0f94c0 c3 a1???????? c3 8bff 55 }
            // n = 7, score = 200
            //   390d????????         |                     
            //   0f94c0               | sete                al
            //   c3                   | ret                 
            //   a1????????           |                     
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   55                   | push                ebp

        $sequence_8 = { ff15???????? 83c40c 8d8d1cf7ffff 51 6802000080 ff15???????? 5f }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   8d8d1cf7ffff         | lea                 ecx, [ebp - 0x8e4]
            //   51                   | push                ecx
            //   6802000080           | push                0x80000002
            //   ff15????????         |                     
            //   5f                   | pop                 edi

        $sequence_9 = { 56 57 8bf9 b9???????? e8???????? 8d45ac 50 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf9                 | mov                 edi, ecx
            //   b9????????           |                     
            //   e8????????           |                     
            //   8d45ac               | lea                 eax, [ebp - 0x54]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 753664
}