rule win_pss_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pss."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pss"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d48fe e8???????? e9???????? 83f811 }
            // n = 4, score = 300
            //   8d48fe               | lea                 ecx, [eax - 2]
            //   e8????????           |                     
            //   e9????????           |                     
            //   83f811               | cmp                 eax, 0x11

        $sequence_1 = { 7437 ff15???????? 3de5030000 752a }
            // n = 4, score = 300
            //   7437                 | je                  0x39
            //   ff15????????         |                     
            //   3de5030000           | cmp                 eax, 0x3e5
            //   752a                 | jne                 0x2c

        $sequence_2 = { ff15???????? 83ceff 3bc6 7504 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   83ceff               | or                  esi, 0xffffffff
            //   3bc6                 | cmp                 eax, esi
            //   7504                 | jne                 6

        $sequence_3 = { 8d4dbc c745fc02000000 e8???????? 8d8550ffffff 50 8d45bc }
            // n = 6, score = 200
            //   8d4dbc               | lea                 ecx, [ebp - 0x44]
            //   c745fc02000000       | mov                 dword ptr [ebp - 4], 2
            //   e8????????           |                     
            //   8d8550ffffff         | lea                 eax, [ebp - 0xb0]
            //   50                   | push                eax
            //   8d45bc               | lea                 eax, [ebp - 0x44]

        $sequence_4 = { 6a00 ff15???????? 50 ff15???????? b001 eb24 e8???????? }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   b001                 | mov                 al, 1
            //   eb24                 | jmp                 0x26
            //   e8????????           |                     

        $sequence_5 = { 8d7f08 8b048d387a0010 ffe0 f7c703000000 }
            // n = 4, score = 200
            //   8d7f08               | lea                 edi, [edi + 8]
            //   8b048d387a0010       | mov                 eax, dword ptr [ecx*4 + 0x10007a38]
            //   ffe0                 | jmp                 eax
            //   f7c703000000         | test                edi, 3

        $sequence_6 = { 83feff 0f8413020000 33c0 8d7c2424 ab ab ab }
            // n = 7, score = 200
            //   83feff               | cmp                 esi, -1
            //   0f8413020000         | je                  0x219
            //   33c0                 | xor                 eax, eax
            //   8d7c2424             | lea                 edi, [esp + 0x24]
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   ab                   | stosd               dword ptr es:[edi], eax

        $sequence_7 = { 51 ff75dc ff15???????? 85c0 751c }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   ff75dc               | push                dword ptr [ebp - 0x24]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   751c                 | jne                 0x1e

        $sequence_8 = { 8bf0 488bcd ff15???????? 85f6 740f 4439b42488000000 }
            // n = 6, score = 100
            //   8bf0                 | je                  0xfffffff0
            //   488bcd               | test                al, 1
            //   ff15????????         |                     
            //   85f6                 | jne                 0x28
            //   740f                 | or                  eax, 1
            //   4439b42488000000     | dec                 eax

        $sequence_9 = { 90 4c89642420 4c89642428 e8???????? }
            // n = 4, score = 100
            //   90                   | nop                 
            //   4c89642420           | dec                 esp
            //   4c89642428           | mov                 dword ptr [esp + 0x20], esp
            //   e8????????           |                     

        $sequence_10 = { 48895d90 4c896588 4488642478 448d430c }
            // n = 4, score = 100
            //   48895d90             | lea                 eax, [0x3dc9]
            //   4c896588             | mov                 esi, eax
            //   4488642478           | dec                 eax
            //   448d430c             | mov                 ecx, ebp

        $sequence_11 = { 750d 48890a 488b4908 44384119 74ea }
            // n = 5, score = 100
            //   750d                 | dec                 esp
            //   48890a               | mov                 dword ptr [esp + 0x28], esp
            //   488b4908             | jne                 0xf
            //   44384119             | dec                 eax
            //   74ea                 | mov                 dword ptr [edx], ecx

        $sequence_12 = { a801 7524 83c801 8905???????? 488d05c93d0000 488905???????? }
            // n = 6, score = 100
            //   a801                 | dec                 eax
            //   7524                 | mov                 ecx, dword ptr [ecx + 8]
            //   83c801               | inc                 esp
            //   8905????????         |                     
            //   488d05c93d0000       | cmp                 byte ptr [ecx + 0x19], al
            //   488905????????       |                     

    condition:
        7 of them and filesize < 421888
}