rule win_pterois_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pterois."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pterois"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f82ff620000 4981f800001800 730d 4981f800200000 0f83c9620000 c5fe6f02 c4a17e6f6c02e0 }
            // n = 7, score = 100
            //   0f82ff620000         | cmp                 eax, 0
            //   4981f800001800       | je                  0x1f3a
            //   730d                 | dec                 esp
            //   4981f800200000       | mov                 ecx, dword ptr [esp + 0x50]
            //   0f83c9620000         | dec                 eax
            //   c5fe6f02             | arpl                word ptr [esp + 0x3c], ax
            //   c4a17e6f6c02e0       | dec                 esp

        $sequence_1 = { 33c9 4c8d057c180100 488d154d6a0100 e8???????? 4885c0 7415 49ba7030525e472705d3 }
            // n = 7, score = 100
            //   33c9                 | mov                 dword ptr [esp], eax
            //   4c8d057c180100       | dec                 eax
            //   488d154d6a0100       | mov                 eax, dword ptr [esp]
            //   e8????????           |                     
            //   4885c0               | dec                 eax
            //   7415                 | mov                 ecx, dword ptr [esp + 8]
            //   49ba7030525e472705d3     | dec    eax

        $sequence_2 = { c744243000000000 8b442430 89442424 488b4c2440 4831e1 e8???????? 8b442424 }
            // n = 7, score = 100
            //   c744243000000000     | je                  0xd2
            //   8b442430             | add                 eax, eax
            //   89442424             | inc                 esp
            //   488b4c2440           | sub                 ebp, eax
            //   4831e1               | je                  0x11a
            //   e8????????           |                     
            //   8b442424             | inc                 ecx

        $sequence_3 = { 75dd 488d055b500100 483bd8 74d1 488bcb e8???????? ebc7 }
            // n = 7, score = 100
            //   75dd                 | jne                 0x10e2
            //   488d055b500100       | dec                 eax
            //   483bd8               | mov                 eax, dword ptr [esp + 0x58]
            //   74d1                 | dec                 eax
            //   488bcb               | mov                 eax, dword ptr [eax + 0x30]
            //   e8????????           |                     
            //   ebc7                 | dec                 eax

        $sequence_4 = { c7401808000000 488b4c2468 488d442470 4829c1 488b442458 48034810 }
            // n = 6, score = 100
            //   c7401808000000       | xor                 eax, esp
            //   488b4c2468           | dec                 eax
            //   488d442470           | mov                 dword ptr [ebp + 0xa70], eax
            //   4829c1               | mov                 al, byte ptr [edx + 8]
            //   488b442458           | dec                 esp
            //   48034810             | lea                 esp, [0xfffecdc6]

        $sequence_5 = { 4829c4 8b842498100000 8b842490100000 488b05???????? 4831e0 4889842460100000 4c894c2458 }
            // n = 7, score = 100
            //   4829c4               | dec                 eax
            //   8b842498100000       | mov                 eax, dword ptr [esp + 0x10]
            //   8b842490100000       | movsx               eax, byte ptr [eax]
            //   488b05????????       |                     
            //   4831e0               | cmp                 eax, 0
            //   4889842460100000     | je                  0x9a8
            //   4c894c2458           | dec                 eax

        $sequence_6 = { 48890d???????? e8???????? 4c8d0d91ce0100 4c8bc0 b201 b9fdffffff e8???????? }
            // n = 7, score = 100
            //   48890d????????       |                     
            //   e8????????           |                     
            //   4c8d0d91ce0100       | dec                 eax
            //   4c8bc0               | mov                 dword ptr [esp + 0x50], eax
            //   b201                 | dec                 eax
            //   b9fdffffff           | mov                 eax, dword ptr [esp + 0x68]
            //   e8????????           |                     

        $sequence_7 = { e8???????? 488b05???????? 4889442430 488d8c24600c0000 e8???????? 4889c1 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   488b05????????       |                     
            //   4889442430           | xor                 eax, eax
            //   488d8c24600c0000     | dec                 eax
            //   e8????????           |                     
            //   4889c1               | cmp                 dword ptr [eax], 0

        $sequence_8 = { e8???????? 83f800 0f851c000000 488b05???????? 488b4c2440 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83f800               | mov                 eax, dword ptr [eax + 0x18]
            //   0f851c000000         | and                 eax, 3
            //   488b05????????       |                     
            //   488b4c2440           | cmp                 eax, 0

        $sequence_9 = { e8???????? 4889442420 48837c242000 0f840c000000 488b442420 c7401802000000 488b442420 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4889442420           | mov                 dword ptr [esp + 0x50], 0
            //   48837c242000         | dec                 eax
            //   0f840c000000         | mov                 eax, dword ptr [esp + 0x38]
            //   488b442420           | dec                 eax
            //   c7401802000000       | mov                 eax, dword ptr [eax + 0x10]
            //   488b442420           | je                  0x564

    condition:
        7 of them and filesize < 528384
}