rule win_purelocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.purelocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.purelocker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8f84240c040000 ffb42410040000 58 89842420040000 8b9c2414040000 3b9c240c040000 0f8da5000000 }
            // n = 7, score = 100
            //   8f84240c040000       | pop                 dword ptr [esp + 0x40c]
            //   ffb42410040000       | push                dword ptr [esp + 0x410]
            //   58                   | pop                 eax
            //   89842420040000       | mov                 dword ptr [esp + 0x420], eax
            //   8b9c2414040000       | mov                 ebx, dword ptr [esp + 0x414]
            //   3b9c240c040000       | cmp                 ebx, dword ptr [esp + 0x40c]
            //   0f8da5000000         | jge                 0xab

        $sequence_1 = { 50 5b 5f 83ffff 7f0b 7c05 83fbff }
            // n = 7, score = 100
            //   50                   | push                eax
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi
            //   83ffff               | cmp                 edi, -1
            //   7f0b                 | jg                  0xd
            //   7c05                 | jl                  7
            //   83fbff               | cmp                 ebx, -1

        $sequence_2 = { e8???????? ffb42458080000 e8???????? 31c0 0fbec0 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   ffb42458080000       | push                dword ptr [esp + 0x858]
            //   e8????????           |                     
            //   31c0                 | xor                 eax, eax
            //   0fbec0               | movsx               eax, al

        $sequence_3 = { 7505 e9???????? 8b9c2450040000 83fb01 0f85c3000000 83bc245804000000 7411 }
            // n = 7, score = 100
            //   7505                 | jne                 7
            //   e9????????           |                     
            //   8b9c2450040000       | mov                 ebx, dword ptr [esp + 0x450]
            //   83fb01               | cmp                 ebx, 1
            //   0f85c3000000         | jne                 0xc9
            //   83bc245804000000     | cmp                 dword ptr [esp + 0x458], 0
            //   7411                 | je                  0x13

        $sequence_4 = { 89442404 ff3424 8d1524400110 59 e8???????? 7415 }
            // n = 6, score = 100
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   ff3424               | push                dword ptr [esp]
            //   8d1524400110         | lea                 edx, [0x10014024]
            //   59                   | pop                 ecx
            //   e8????????           |                     
            //   7415                 | je                  0x17

        $sequence_5 = { 750e 837c240400 7407 b801000000 eb02 31c0 21c0 }
            // n = 7, score = 100
            //   750e                 | jne                 0x10
            //   837c240400           | cmp                 dword ptr [esp + 4], 0
            //   7407                 | je                  9
            //   b801000000           | mov                 eax, 1
            //   eb02                 | jmp                 4
            //   31c0                 | xor                 eax, eax
            //   21c0                 | and                 eax, eax

        $sequence_6 = { 7c11 8b5c2420 3b5c2428 7f07 b801000000 eb02 }
            // n = 6, score = 100
            //   7c11                 | jl                  0x13
            //   8b5c2420             | mov                 ebx, dword ptr [esp + 0x20]
            //   3b5c2428             | cmp                 ebx, dword ptr [esp + 0x28]
            //   7f07                 | jg                  9
            //   b801000000           | mov                 eax, 1
            //   eb02                 | jmp                 4

        $sequence_7 = { e9???????? 6819000000 68ffffffff ff742414 ff742420 e8???????? ff742410 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   6819000000           | push                0x19
            //   68ffffffff           | push                0xffffffff
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   ff742420             | push                dword ptr [esp + 0x20]
            //   e8????????           |                     
            //   ff742410             | push                dword ptr [esp + 0x10]

        $sequence_8 = { 52 e8???????? 5a 50 ff742408 e8???????? 8d44241c }
            // n = 7, score = 100
            //   52                   | push                edx
            //   e8????????           |                     
            //   5a                   | pop                 edx
            //   50                   | push                eax
            //   ff742408             | push                dword ptr [esp + 8]
            //   e8????????           |                     
            //   8d44241c             | lea                 eax, [esp + 0x1c]

        $sequence_9 = { ffb424bc000000 e8???????? 0fbe842488000000 0fbec0 e9???????? ff742474 }
            // n = 6, score = 100
            //   ffb424bc000000       | push                dword ptr [esp + 0xbc]
            //   e8????????           |                     
            //   0fbe842488000000     | movsx               eax, byte ptr [esp + 0x88]
            //   0fbec0               | movsx               eax, al
            //   e9????????           |                     
            //   ff742474             | push                dword ptr [esp + 0x74]

    condition:
        7 of them and filesize < 193536
}