rule win_pvzout_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.pvzout."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.pvzout"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { d4a1 0e 75a8 43 }
            // n = 4, score = 200
            //   d4a1                 | aam                 0xa1
            //   0e                   | push                cs
            //   75a8                 | jne                 0xffffffaa
            //   43                   | inc                 ebx

        $sequence_1 = { bf95f6810e 75a8 43 1dea50873a d4a1 0e }
            // n = 6, score = 200
            //   bf95f6810e           | mov                 edi, 0xe81f695
            //   75a8                 | jne                 0xffffffaa
            //   43                   | inc                 ebx
            //   1dea50873a           | sbb                 eax, 0x3a8750ea
            //   d4a1                 | aam                 0xa1
            //   0e                   | push                cs

        $sequence_2 = { 43 1dea50873a d4a1 0e 75a8 43 1dea50873a }
            // n = 7, score = 200
            //   43                   | inc                 ebx
            //   1dea50873a           | sbb                 eax, 0x3a8750ea
            //   d4a1                 | aam                 0xa1
            //   0e                   | push                cs
            //   75a8                 | jne                 0xffffffaa
            //   43                   | inc                 ebx
            //   1dea50873a           | sbb                 eax, 0x3a8750ea

        $sequence_3 = { 1dea50873a d4a1 0e 75a8 43 1dea50873a }
            // n = 6, score = 200
            //   1dea50873a           | sbb                 eax, 0x3a8750ea
            //   d4a1                 | aam                 0xa1
            //   0e                   | push                cs
            //   75a8                 | jne                 0xffffffaa
            //   43                   | inc                 ebx
            //   1dea50873a           | sbb                 eax, 0x3a8750ea

        $sequence_4 = { 3089f33d80f3 48 e21c 3e3f 19e9 }
            // n = 5, score = 200
            //   3089f33d80f3         | xor                 byte ptr [ecx - 0xc7fc20d], cl
            //   48                   | dec                 eax
            //   e21c                 | loop                0x1e
            //   3e3f                 | aas                 
            //   19e9                 | sbb                 ecx, ebp

        $sequence_5 = { 18830d88a01c 51 ab 25b53ae778 f3bd95ab4ed8 }
            // n = 5, score = 200
            //   18830d88a01c         | sbb                 byte ptr [ebx + 0x1ca0880d], al
            //   51                   | push                ecx
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   25b53ae778           | and                 eax, 0x78e73ab5
            //   f3bd95ab4ed8         | mov                 ebp, 0xd84eab95

        $sequence_6 = { 1dea50873a d4a1 0e 75a8 }
            // n = 4, score = 200
            //   1dea50873a           | sbb                 eax, 0x3a8750ea
            //   d4a1                 | aam                 0xa1
            //   0e                   | push                cs
            //   75a8                 | jne                 0xffffffaa

        $sequence_7 = { 19e9 73f8 dca10ebd24e8 252b0026cb 9e }
            // n = 5, score = 200
            //   19e9                 | sbb                 ecx, ebp
            //   73f8                 | jae                 0xfffffffa
            //   dca10ebd24e8         | fsub                qword ptr [ecx - 0x17db42f2]
            //   252b0026cb           | and                 eax, 0xcb26002b
            //   9e                   | sahf                

        $sequence_8 = { d4a1 0e 75a8 43 2f 3089f33d80f3 }
            // n = 6, score = 200
            //   d4a1                 | aam                 0xa1
            //   0e                   | push                cs
            //   75a8                 | jne                 0xffffffaa
            //   43                   | inc                 ebx
            //   2f                   | das                 
            //   3089f33d80f3         | xor                 byte ptr [ecx - 0xc7fc20d], cl

        $sequence_9 = { 5a bf95f6810e 75a8 43 }
            // n = 4, score = 200
            //   5a                   | pop                 edx
            //   bf95f6810e           | mov                 edi, 0xe81f695
            //   75a8                 | jne                 0xffffffaa
            //   43                   | inc                 ebx

    condition:
        7 of them and filesize < 573440
}