rule win_qadars_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.qadars."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.qadars"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7410 8d642400 8b0b 48 c7048100000000 75f4 }
            // n = 7, score = 700
            //   85c0                 | test                eax, eax
            //   7410                 | je                  0x12
            //   8d642400             | lea                 esp, [esp]
            //   8b0b                 | mov                 ecx, dword ptr [ebx]
            //   48                   | dec                 eax
            //   c7048100000000       | mov                 dword ptr [ecx + eax*4], 0
            //   75f4                 | jne                 0xfffffff6

        $sequence_1 = { 8910 8b4510 85c0 7406 c700???????? 8b4514 }
            // n = 6, score = 700
            //   8910                 | mov                 dword ptr [eax], edx
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   85c0                 | test                eax, eax
            //   7406                 | je                  8
            //   c700????????         |                     
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]

        $sequence_2 = { 56 8d4dcc e8???????? 8d4dcc e8???????? 8bc6 5e }
            // n = 7, score = 700
            //   56                   | push                esi
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   e8????????           |                     
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi

        $sequence_3 = { 8b4dec 39590c 7405 ff490c eb25 8b4104 3bc3 }
            // n = 7, score = 700
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   39590c               | cmp                 dword ptr [ecx + 0xc], ebx
            //   7405                 | je                  7
            //   ff490c               | dec                 dword ptr [ecx + 0xc]
            //   eb25                 | jmp                 0x27
            //   8b4104               | mov                 eax, dword ptr [ecx + 4]
            //   3bc3                 | cmp                 eax, ebx

        $sequence_4 = { 6a04 8d550c 52 8d443801 }
            // n = 4, score = 700
            //   6a04                 | push                4
            //   8d550c               | lea                 edx, [ebp + 0xc]
            //   52                   | push                edx
            //   8d443801             | lea                 eax, [eax + edi + 1]

        $sequence_5 = { 8945fc 8b45e8 6a10 8945f8 e8???????? 83c404 }
            // n = 6, score = 700
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   6a10                 | push                0x10
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_6 = { 8b4510 8b08 51 52 8d4df0 897704 8975f4 }
            // n = 7, score = 700
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   897704               | mov                 dword ptr [edi + 4], esi
            //   8975f4               | mov                 dword ptr [ebp - 0xc], esi

        $sequence_7 = { 8b00 50 e8???????? 8b45fc 50 e8???????? 83c408 }
            // n = 7, score = 700
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_8 = { 6a00 8d4df4 51 6a04 8d55f8 }
            // n = 5, score = 600
            //   6a00                 | push                0
            //   8d4df4               | lea                 ecx, [ebp - 0xc]
            //   51                   | push                ecx
            //   6a04                 | push                4
            //   8d55f8               | lea                 edx, [ebp - 8]

        $sequence_9 = { 83c40c 6805010000 8d8df8feffff 51 }
            // n = 4, score = 300
            //   83c40c               | add                 esp, 0xc
            //   6805010000           | push                0x105
            //   8d8df8feffff         | lea                 ecx, [ebp - 0x108]
            //   51                   | push                ecx

        $sequence_10 = { 6a01 8b55fc 52 ff15???????? 83c408 }
            // n = 5, score = 300
            //   6a01                 | push                1
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   83c408               | add                 esp, 8

        $sequence_11 = { 6a01 6a08 ff15???????? 83c408 }
            // n = 4, score = 300
            //   6a01                 | push                1
            //   6a08                 | push                8
            //   ff15????????         |                     
            //   83c408               | add                 esp, 8

        $sequence_12 = { 51 8b55f0 52 ff15???????? 83c40c }
            // n = 5, score = 300
            //   51                   | push                ecx
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_13 = { 50 8d8d98fcffff 51 e8???????? }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8d8d98fcffff         | lea                 ecx, [ebp - 0x368]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_14 = { 8945fc 6a02 8b85d4fdffff 50 }
            // n = 4, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   6a02                 | push                2
            //   8b85d4fdffff         | mov                 eax, dword ptr [ebp - 0x22c]
            //   50                   | push                eax

        $sequence_15 = { 750b 68???????? ff15???????? 6a00 }
            // n = 4, score = 100
            //   750b                 | jne                 0xd
            //   68????????           |                     
            //   ff15????????         |                     
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 630784
}