rule win_qakbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.qakbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.qakbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 7402 ebfa e8???????? }
            // n = 4, score = 15500
            //   33c0                 | xor                 eax, eax
            //   7402                 | je                  4
            //   ebfa                 | jmp                 0xfffffffc
            //   e8????????           |                     

        $sequence_1 = { 7402 ebfa 33c0 7402 }
            // n = 4, score = 15400
            //   7402                 | je                  4
            //   ebfa                 | jmp                 0xfffffffc
            //   33c0                 | xor                 eax, eax
            //   7402                 | je                  4

        $sequence_2 = { 7402 ebfa eb06 33c0 }
            // n = 4, score = 14900
            //   7402                 | je                  4
            //   ebfa                 | jmp                 0xfffffffc
            //   eb06                 | jmp                 8
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 50 e8???????? 8b06 47 59 }
            // n = 5, score = 14400
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   47                   | inc                 edi
            //   59                   | pop                 ecx

        $sequence_4 = { 59 59 6afb e9???????? }
            // n = 4, score = 13800
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   6afb                 | push                -5
            //   e9????????           |                     

        $sequence_5 = { 740d 8d45fc 6a00 50 }
            // n = 4, score = 13700
            //   740d                 | je                  0xf
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_6 = { 48 50 8d8534f6ffff 6a00 50 e8???????? }
            // n = 6, score = 13700
            //   48                   | dec                 eax
            //   50                   | push                eax
            //   8d8534f6ffff         | lea                 eax, [ebp - 0x9cc]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_7 = { 50 e8???????? 59 59 6afe 58 }
            // n = 6, score = 13500
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   6afe                 | push                -2
            //   58                   | pop                 eax

        $sequence_8 = { 8945fc e8???????? 8bf0 8d45fc 50 e8???????? }
            // n = 6, score = 13500
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_9 = { 33c0 e9???????? 33c0 7402 }
            // n = 4, score = 13400
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   33c0                 | xor                 eax, eax
            //   7402                 | je                  4

        $sequence_10 = { 7402 ebfa e9???????? 6a00 }
            // n = 4, score = 13200
            //   7402                 | je                  4
            //   ebfa                 | jmp                 0xfffffffc
            //   e9????????           |                     
            //   6a00                 | push                0

        $sequence_11 = { eb0b c644301c00 ff465c 8b465c }
            // n = 4, score = 13000
            //   eb0b                 | jl                  0xfffffff1
            //   c644301c00           | jmp                 0x14
            //   ff465c               | mov                 byte ptr [eax + esi + 0x1c], 0
            //   8b465c               | inc                 dword ptr [esi + 0x5c]

        $sequence_12 = { 7cef eb10 c644301c00 ff465c }
            // n = 4, score = 13000
            //   7cef                 | mov                 ebp, esp
            //   eb10                 | sub                 esp, 0x9c4
            //   c644301c00           | push                eax
            //   ff465c               | lea                 eax, [ebp - 0x9cc]

        $sequence_13 = { e8???????? 83c410 33c0 7402 }
            // n = 4, score = 12800
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   33c0                 | xor                 eax, eax
            //   7402                 | je                  4

        $sequence_14 = { 5e c9 c3 55 8bec 81ecc4090000 }
            // n = 6, score = 12800
            //   5e                   | pop                 esi
            //   c9                   | leave               
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ecc4090000         | sub                 esp, 0x9c4

        $sequence_15 = { 85c0 750a 33c0 7402 }
            // n = 4, score = 12700
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc
            //   33c0                 | xor                 eax, eax
            //   7402                 | je                  4

        $sequence_16 = { 7507 c7466401000000 83f840 7507 }
            // n = 4, score = 12400
            //   7507                 | ret                 
            //   c7466401000000       | push                ebp
            //   83f840               | mov                 ebp, esp
            //   7507                 | sub                 esp, 0x9cc

        $sequence_17 = { 837dfc00 750b 33c0 7402 }
            // n = 4, score = 12300
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   750b                 | jne                 0xd
            //   33c0                 | xor                 eax, eax
            //   7402                 | je                  4

        $sequence_18 = { e8???????? e8???????? 33c0 7402 }
            // n = 4, score = 12300
            //   e8????????           |                     
            //   e8????????           |                     
            //   33c0                 | jmp                 4
            //   7402                 | jmp                 0xfffffffc

        $sequence_19 = { 833d????????00 7508 33c0 7402 }
            // n = 4, score = 12100
            //   833d????????00       |                     
            //   7508                 | jmp                 0
            //   33c0                 | jne                 0xf
            //   7402                 | xor                 eax, eax

        $sequence_20 = { c7466001000000 33c0 40 5e }
            // n = 4, score = 11900
            //   c7466001000000       | mov                 byte ptr [esi + eax + 0x1c], 0
            //   33c0                 | inc                 dword ptr [esi + 0x5c]
            //   40                   | cmp                 dword ptr [esi + 0x5c], 0x38
            //   5e                   | jl                  0xfffffff8

        $sequence_21 = { 7402 ebfa 837d1000 7408 }
            // n = 4, score = 11600
            //   7402                 | je                  4
            //   ebfa                 | jmp                 0xfffffffc
            //   837d1000             | cmp                 dword ptr [ebp + 0x10], 0
            //   7408                 | je                  0xa

        $sequence_22 = { 80ea80 8855f0 e8???????? 0fb64df7 }
            // n = 4, score = 11600
            //   80ea80               | jmp                 0x1b
            //   8855f0               | mov                 byte ptr [eax + esi + 0x1c], 0
            //   e8????????           |                     
            //   0fb64df7             | mov                 byte ptr [esi + eax + 0x1c], 0

        $sequence_23 = { 83f841 7c05 83f85a 7eeb 83f861 }
            // n = 5, score = 11500
            //   83f841               | cmp                 eax, 0x41
            //   7c05                 | jl                  7
            //   83f85a               | cmp                 eax, 0x5a
            //   7eeb                 | jle                 0xffffffed
            //   83f861               | cmp                 eax, 0x61

        $sequence_24 = { 7eeb 83f861 7c05 83f87a }
            // n = 4, score = 11500
            //   7eeb                 | jle                 0xffffffed
            //   83f861               | cmp                 eax, 0x61
            //   7c05                 | jl                  7
            //   83f87a               | cmp                 eax, 0x7a

        $sequence_25 = { e8???????? 833822 7505 83c8ff }
            // n = 4, score = 10100
            //   e8????????           |                     
            //   833822               | cmp                 dword ptr [eax], 0x22
            //   7505                 | jne                 7
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_26 = { 6a00 50 e8???????? 6a00 57 e8???????? }
            // n = 6, score = 9900
            //   6a00                 | jmp                 0xfffffffe
            //   50                   | cmp                 dword ptr [ebp + 0x10], 0
            //   e8????????           |                     
            //   6a00                 | push                esi
            //   57                   | add                 esp, 0xc
            //   e8????????           |                     

        $sequence_27 = { b301 eb0c 813800300000 b302 7202 }
            // n = 5, score = 9800
            //   b301                 | mov                 bl, 1
            //   eb0c                 | jmp                 0xe
            //   813800300000         | cmp                 dword ptr [eax], 0x3000
            //   b302                 | mov                 bl, 2
            //   7202                 | jb                  4

        $sequence_28 = { 7418 813800200000 7304 b301 eb0c }
            // n = 5, score = 9800
            //   7418                 | je                  0x1a
            //   813800200000         | cmp                 dword ptr [eax], 0x2000
            //   7304                 | jae                 6
            //   b301                 | mov                 bl, 1
            //   eb0c                 | jmp                 0xe

        $sequence_29 = { c1e81e 33448afc 69c06589076c 03c1 89048a ff82c0090000 81bac009000070020000 }
            // n = 7, score = 9600
            //   c1e81e               | shr                 eax, 0x1e
            //   33448afc             | xor                 eax, dword ptr [edx + ecx*4 - 4]
            //   69c06589076c         | imul                eax, eax, 0x6c078965
            //   03c1                 | add                 eax, ecx
            //   89048a               | mov                 dword ptr [edx + ecx*4], eax
            //   ff82c0090000         | inc                 dword ptr [edx + 0x9c0]
            //   81bac009000070020000     | cmp    dword ptr [edx + 0x9c0], 0x270

        $sequence_30 = { ff10 85c0 750b ff15???????? e9???????? }
            // n = 5, score = 9500
            //   ff10                 | call                dword ptr [eax]
            //   85c0                 | test                eax, eax
            //   750b                 | jne                 0xd
            //   ff15????????         |                     
            //   e9????????           |                     

        $sequence_31 = { 50 8d45d8 50 8d45d4 50 8d45ec 50 }
            // n = 7, score = 9500
            //   50                   | mov                 byte ptr [esi + edi], 0
            //   8d45d8               | mov                 eax, esi
            //   50                   | pop                 edi
            //   8d45d4               | pop                 esi
            //   50                   | jmp                 0x17
            //   8d45ec               | xor                 eax, eax
            //   50                   | je                  6

        $sequence_32 = { 7507 e8???????? 8bc8 890d???????? }
            // n = 4, score = 9300
            //   7507                 | jne                 9
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   890d????????         |                     

        $sequence_33 = { 83f801 7513 85c9 7507 e8???????? }
            // n = 5, score = 9300
            //   83f801               | cmp                 eax, 1
            //   7513                 | jne                 0x15
            //   85c9                 | test                ecx, ecx
            //   7507                 | jne                 9
            //   e8????????           |                     

        $sequence_34 = { 6a00 6800600900 6a00 ff15???????? a3???????? }
            // n = 5, score = 8800
            //   6a00                 | jmp                 2
            //   6800600900           | je                  4
            //   6a00                 | jmp                 0xfffffffc
            //   ff15????????         |                     
            //   a3????????           |                     

        $sequence_35 = { e8???????? 33c0 c3 55 8bec 51 51 }
            // n = 7, score = 8500
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   51                   | push                ecx

        $sequence_36 = { 50 ff5508 8bf0 59 }
            // n = 4, score = 6300
            //   50                   | push                eax
            //   ff5508               | call                dword ptr [ebp + 8]
            //   8bf0                 | mov                 esi, eax
            //   59                   | pop                 ecx

        $sequence_37 = { 6a00 58 0f95c0 40 50 }
            // n = 5, score = 5800
            //   6a00                 | push                0
            //   58                   | pop                 eax
            //   0f95c0               | setne               al
            //   40                   | inc                 eax
            //   50                   | push                eax

        $sequence_38 = { c3 33c9 3d80000000 0f94c1 }
            // n = 4, score = 5200
            //   c3                   | ret                 
            //   33c9                 | xor                 ecx, ecx
            //   3d80000000           | cmp                 eax, 0x80
            //   0f94c1               | sete                cl

        $sequence_39 = { 750c 57 ff15???????? 6afe 58 }
            // n = 5, score = 5200
            //   750c                 | jne                 0xe
            //   57                   | push                edi
            //   ff15????????         |                     
            //   6afe                 | push                -2
            //   58                   | pop                 eax

        $sequence_40 = { 57 ff15???????? 33c0 85f6 0f94c0 }
            // n = 5, score = 5200
            //   57                   | push                edi
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   85f6                 | test                esi, esi
            //   0f94c0               | sete                al

        $sequence_41 = { 57 6a00 6a02 ff15???????? 8bf8 83c8ff 3bf8 }
            // n = 7, score = 5000
            //   57                   | push                edi
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   83c8ff               | or                  eax, 0xffffffff
            //   3bf8                 | cmp                 edi, eax

        $sequence_42 = { 50 e8???????? 6a40 8d4590 }
            // n = 4, score = 4500
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a40                 | push                0x40
            //   8d4590               | lea                 eax, [ebp - 0x70]

        $sequence_43 = { 56 e8???????? 83c40c 8d4514 50 }
            // n = 5, score = 4000
            //   56                   | jmp                 0xfffffffc
            //   e8????????           |                     
            //   83c40c               | jmp                 8
            //   8d4514               | xor                 eax, eax
            //   50                   | je                  8

        $sequence_44 = { c7871002000001000000 8bc3 eb02 33c0 }
            // n = 4, score = 2800
            //   c7871002000001000000     | mov    dword ptr [edi + 0x210], 1
            //   8bc3                 | mov                 eax, ebx
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_45 = { e8???????? e8???????? e8???????? e8???????? 85c0 7405 e8???????? }
            // n = 7, score = 2800
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   e8????????           |                     

        $sequence_46 = { eb13 488bd3 488bce ff15???????? }
            // n = 4, score = 800
            //   eb13                 | lea                 edi, [ebx + 1]
            //   488bd3               | mov                 eax, ecx
            //   488bce               | jmp                 7
            //   ff15????????         |                     

        $sequence_47 = { eb05 be01000000 488b15???????? 488b4d48 ff5220 488b15???????? }
            // n = 6, score = 800
            //   eb05                 | dec                 ebp
            //   be01000000           | mov                 eax, ebx
            //   488b15????????       |                     
            //   488b4d48             | xor                 edx, edx
            //   ff5220               | dec                 ecx
            //   488b15????????       |                     

        $sequence_48 = { f7d9 eb03 4d8bda 4d8bc3 33d2 498d7b01 }
            // n = 6, score = 800
            //   f7d9                 | neg                 ecx
            //   eb03                 | jmp                 5
            //   4d8bda               | dec                 ebp
            //   4d8bc3               | mov                 ebx, edx
            //   33d2                 | dec                 ebp
            //   498d7b01             | mov                 eax, ebx

        $sequence_49 = { e8???????? 6a00 8d45d4 50 68???????? }
            // n = 5, score = 500
            //   e8????????           |                     
            //   6a00                 | push                esi
            //   8d45d4               | add                 esp, 0xc
            //   50                   | lea                 eax, [ebp + 0x14]
            //   68????????           |                     

        $sequence_50 = { 5d c3 33c9 66890c46 }
            // n = 4, score = 300
            //   5d                   | push                eax
            //   c3                   | push                edi
            //   33c9                 | push                0
            //   66890c46             | push                esi

        $sequence_51 = { 8974240c 8a742431 80c63d 28d6 8874240b 69f60ea9c735 89742404 }
            // n = 7, score = 100
            //   8974240c             | mov                 dword ptr [esp + 0xc], esi
            //   8a742431             | mov                 dh, byte ptr [esp + 0x31]
            //   80c63d               | add                 dh, 0x3d
            //   28d6                 | sub                 dh, dl
            //   8874240b             | mov                 byte ptr [esp + 0xb], dh
            //   69f60ea9c735         | imul                esi, esi, 0x35c7a90e
            //   89742404             | mov                 dword ptr [esp + 4], esi

        $sequence_52 = { 69f63c13b648 01f2 89442428 8954242c }
            // n = 4, score = 100
            //   69f63c13b648         | imul                esi, esi, 0x48b6133c
            //   01f2                 | add                 edx, esi
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   8954242c             | mov                 dword ptr [esp + 0x2c], edx

        $sequence_53 = { 8955cc 74bf e9???????? 55 89e5 83ec08 c745fca1552064 }
            // n = 7, score = 100
            //   8955cc               | mov                 dword ptr [ebp - 0x34], edx
            //   74bf                 | je                  0xffffffc1
            //   e9????????           |                     
            //   55                   | push                ebp
            //   89e5                 | mov                 ebp, esp
            //   83ec08               | sub                 esp, 8
            //   c745fca1552064       | mov                 dword ptr [ebp - 4], 0x642055a1

        $sequence_54 = { 0f4cc8 8b442408 890424 894c2404 8b4c2444 ffd1 83ec08 }
            // n = 7, score = 100
            //   0f4cc8               | cmovl               ecx, eax
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   890424               | mov                 dword ptr [esp], eax
            //   894c2404             | mov                 dword ptr [esp + 4], ecx
            //   8b4c2444             | mov                 ecx, dword ptr [esp + 0x44]
            //   ffd1                 | call                ecx
            //   83ec08               | sub                 esp, 8

        $sequence_55 = { 8b84248c000000 35fc387373 8b4c2470 01c1 }
            // n = 4, score = 100
            //   8b84248c000000       | mov                 eax, dword ptr [esp + 0x8c]
            //   35fc387373           | xor                 eax, 0x737338fc
            //   8b4c2470             | mov                 ecx, dword ptr [esp + 0x70]
            //   01c1                 | add                 ecx, eax

        $sequence_56 = { 57 85c0 0f8445010000 8b3d???????? }
            // n = 4, score = 100
            //   57                   | lea                 eax, [ebp + 0x14]
            //   85c0                 | push                eax
            //   0f8445010000         | push                edi
            //   8b3d????????         |                     

        $sequence_57 = { 66660f1f840000000000 8b4c9604 330c96 81e1ffffff7f }
            // n = 4, score = 100
            //   66660f1f840000000000     | push    0
            //   8b4c9604             | push                esi
            //   330c96               | add                 esp, 0xc
            //   81e1ffffff7f         | lea                 eax, [ebp + 0x14]

        $sequence_58 = { 8b442438 8b4c243c 8b11 83fa00 8944241c 894c2420 }
            // n = 6, score = 100
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]
            //   8b4c243c             | mov                 ecx, dword ptr [esp + 0x3c]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   83fa00               | cmp                 edx, 0
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   894c2420             | mov                 dword ptr [esp + 0x20], ecx

        $sequence_59 = { c785f8f9ffff00000000 6a00 56 8bf9 e8???????? }
            // n = 5, score = 100
            //   c785f8f9ffff00000000     | lea    eax, [ebp + 0x14]
            //   6a00                 | push                0
            //   56                   | push                esi
            //   8bf9                 | add                 esp, 0xc
            //   e8????????           |                     

        $sequence_60 = { 8b742418 8b7c241c f7d7 f7d6 89742418 }
            // n = 5, score = 100
            //   8b742418             | mov                 esi, dword ptr [esp + 0x18]
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]
            //   f7d7                 | not                 edi
            //   f7d6                 | not                 esi
            //   89742418             | mov                 dword ptr [esp + 0x18], esi

        $sequence_61 = { 7536 56 50 ff35???????? ff15???????? 8b85c0faffff 85c0 }
            // n = 7, score = 100
            //   7536                 | push                0
            //   56                   | lea                 eax, [ebp - 0x2c]
            //   50                   | push                eax
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   8b85c0faffff         | pop                 ebp
            //   85c0                 | ret                 

        $sequence_62 = { 880c1a 8a4df3 324df3 884df3 83c301 8b55ec 39d3 }
            // n = 7, score = 100
            //   880c1a               | mov                 byte ptr [edx + ebx], cl
            //   8a4df3               | mov                 cl, byte ptr [ebp - 0xd]
            //   324df3               | xor                 cl, byte ptr [ebp - 0xd]
            //   884df3               | mov                 byte ptr [ebp - 0xd], cl
            //   83c301               | add                 ebx, 1
            //   8b55ec               | mov                 edx, dword ptr [ebp - 0x14]
            //   39d3                 | cmp                 ebx, edx

    condition:
        7 of them and filesize < 4883456
}